package com.digiwin.athena.base.application.service.trial;


import com.digiwin.athena.base.application.meta.request.trial.step.TrialStepReq;
import com.digiwin.athena.base.application.meta.request.trial.step.TrialStepResp;
import com.digiwin.athena.base.infrastructure.meta.po.trial.TrialStepData;

import java.util.List;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2021/09/03 15:44:27
 */
public interface TrialStepService {
    /**
     * 新增试用步骤
     *
     * @param stepReq stepReq
     * @return int
     */
    Long add(TrialStepReq stepReq);

    /**
     * 修改试用步骤
     *
     * @param stepReq stepReq
     * @return int
     */
    int modify(TrialStepReq stepReq);

    /**
     * 查询试用步骤列表
     *
     * @return list
     */
    List<TrialStepData> list(TrialStepReq stepReq);

    /**
     * 根据id删除试用步骤
     *
     * @param id id
     * @return int
     */
    int deleteById(Long id);

    /**
     * 查询试用步骤列表
     *
     * @return list
     */
    TrialStepResp detail(String stepKey);
}
