package com.digiwin.athena.base.application.service.usertrack;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.application.meta.request.usertrack.AccountDTO;
import com.digiwin.athena.base.application.meta.request.usertrack.UserTrackSearchDTO;
import com.digiwin.athena.base.infrastructure.meta.po.usertrack.mongo.UserTrackExtendDTO;

import java.util.List;
import java.util.Map;

/**
 * UserTrackService Description
 *
 * @author majianfu
 * @date 2021/8/27
 * @since
 */
public interface UserTrackService {
    /**
     * 处理上报的数据，包含：用户行为轨迹、性能分析、功能分析
     *
     * @param reportDataList 用户行为轨迹上报信息
     */
    void handleReportData(List<UserTrackExtendDTO> reportDataList);

    /**
     * 清除上报数据
     *
     * @param account
     */
    void clearReportData(AccountDTO account);

    /**
     * 查询数据
     *
     * @param searchDTO
     * @return
     */
    Map<String, Object> findByParam(UserTrackSearchDTO searchDTO, AuthoredUser user);
}
