/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.userdefined;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.base.application.meta.dto.userdefined.UserOperationMsgEvent;
import com.digiwin.athena.base.application.meta.request.userdefined.UserPageModelBodyDTO;
import com.digiwin.athena.base.application.meta.response.userdefined.TakeUpRecordDTO;
import com.digiwin.athena.base.application.meta.response.userdefined.UserPageModelRespDTO;
import com.digiwin.athena.base.infrastructure.constant.Constants;
import com.digiwin.athena.base.infrastructure.mapper.audc.userdefined.UserOperationRecordMapper;
import com.digiwin.athena.base.infrastructure.meta.po.userdefined.UserOperationRecordDTO;
import com.digiwin.athena.base.infrastructure.util.DistributeLocker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserPageModelParentService {
    private static final Logger log = LoggerFactory.getLogger(UserPageModelParentService.class);
    @Autowired
    private UserOperationRecordMapper userOperationRecordMapper;
    @Resource(name="redisTemplate")
    private RedisTemplate lockRedisTemplate;
    @Autowired
    private TokenVerifyService tokenVerifyService;
    protected static final String UNDER_PLACE = ":";
    protected static final String KEY_PREFIX = "audc:";
    protected static final List<String> CHECK_ITEM = Lists.newArrayList((Object[])new String[]{"baseDataEntryProjectMemorabilia", "DataEntry_testflow_sign_document", "DataEntry_sign_document_model"});

    protected boolean isCheckItem(UserPageModelBodyDTO pageModelBodyDTO) {
        if (pageModelBodyDTO == null) {
            return false;
        }
        if (StringUtils.isEmpty((String)pageModelBodyDTO.getActivityCode())) {
            return false;
        }
        return CHECK_ITEM.contains(pageModelBodyDTO.getActivityCode());
    }

    public String getLockKey(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        return "";
    }

    public String getLockKey(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO, String businessKey) {
        return "";
    }

    public boolean getLock(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        String lockVal = authoredUser.getUserId();
        try {
            if (CollectionUtils.isEmpty(pageModelBodyDTO.getBusinessKeys())) {
                return DistributeLocker.tryLock((RedisTemplate)this.lockRedisTemplate, (String)this.getLockKey(authoredUser, pageModelBodyDTO), (String)lockVal, (long)3L, (TimeUnit)TimeUnit.SECONDS);
            }
            for (String businessKey : pageModelBodyDTO.getBusinessKeys()) {
                DistributeLocker.tryLock((RedisTemplate)this.lockRedisTemplate, (String)this.getLockKey(authoredUser, pageModelBodyDTO, businessKey), (String)lockVal, (long)3L, (TimeUnit)TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            log.error("\u9875\u9762\u7f16\u8f91\u6001\u83b7\u53d6\u9501\u5931\u8d25:{}", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return true;
    }

    public void releaseLock(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        try {
            if (CollectionUtils.isEmpty(pageModelBodyDTO.getBusinessKeys())) {
                DistributeLocker.releaseLock((RedisTemplate)this.lockRedisTemplate, (String)this.getLockKey(authoredUser, pageModelBodyDTO));
            } else {
                pageModelBodyDTO.getBusinessKeys().forEach(businessKey -> DistributeLocker.releaseLock((RedisTemplate)this.lockRedisTemplate, (String)this.getLockKey(authoredUser, pageModelBodyDTO, (String)businessKey)));
            }
        }
        catch (Exception e) {
            log.error("\u9875\u9762\u7f16\u8f91\u6001\u89e3\u9501\u5931\u8d25:{}", (Throwable)e);
        }
    }

    public UserPageModelRespDTO getEdit(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        return new UserPageModelRespDTO();
    }

    public UserPageModelRespDTO updateEdit(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        return new UserPageModelRespDTO();
    }

    public Boolean deleteEdit(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        return true;
    }

    public Boolean reportStatus(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        return true;
    }

    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int deleteExpire() {
        LocalDateTime updateTime = LocalDateTime.now().minus(Constants.USER_OPERATION_TTL, ChronoUnit.SECONDS);
        HashMap queryExpireRecordsParams = Maps.newHashMap();
        queryExpireRecordsParams.put("takeUp", "1");
        queryExpireRecordsParams.put("updateTime", updateTime);
        List expiredTakeUpRecords = this.userOperationRecordMapper.queryExpireRecords((Map)queryExpireRecordsParams);
        UserOperationRecordDTO userOperationRecordDTO = new UserOperationRecordDTO();
        userOperationRecordDTO.setUpdateTime(updateTime);
        int result = this.userOperationRecordMapper.deleteExpire(userOperationRecordDTO);
        if (CollectionUtils.isEmpty((Collection)expiredTakeUpRecords) && result > 0) {
            return result;
        }
        HashMap expiredTakeUpRecordMap = new HashMap();
        expiredTakeUpRecords.forEach(expiredTakeUpRecord -> {
            String key = expiredTakeUpRecord.getTenantId() + UNDER_PLACE + expiredTakeUpRecord.getPageCode();
            if (expiredTakeUpRecordMap.containsKey(key)) {
                ((List)expiredTakeUpRecordMap.get(key)).add(expiredTakeUpRecord);
            } else {
                expiredTakeUpRecordMap.put(key, new ArrayList<UserOperationRecordDTO>(Arrays.asList(expiredTakeUpRecord)));
            }
        });
        expiredTakeUpRecordMap.values().forEach(expiredTakeUpRecordList -> {
            HashMap queryNoTakeUpParams = Maps.newHashMap();
            UserOperationRecordDTO expiredTakeUpRecord = (UserOperationRecordDTO)expiredTakeUpRecordList.get(0);
            queryNoTakeUpParams.put("tenantId", expiredTakeUpRecord.getTenantId());
            queryNoTakeUpParams.put("pageType", expiredTakeUpRecord.getPageType());
            queryNoTakeUpParams.put("pageCode", expiredTakeUpRecord.getPageCode());
            queryNoTakeUpParams.put("updateTime", updateTime);
            List<UserOperationRecordDTO> noTakeUpList = this.queryEffectiveRecords(queryNoTakeUpParams);
            if (!CollectionUtils.isEmpty(noTakeUpList)) {
                String token = this.tokenVerifyService.queryApiVirtualToken(expiredTakeUpRecord.getTenantId());
                List<String> userIdList = noTakeUpList.stream().map(UserOperationRecordDTO::getUserId).distinct().collect(Collectors.toList());
                this.sendMessageToClient(this.processMsgEvent(token, (List<UserOperationRecordDTO>)expiredTakeUpRecordList, "baseDataEntry", "release"), userIdList);
            }
        });
        return result;
    }

    public void sendMessageToClient(UserOperationMsgEvent userOperationMsgEvent, List<String> userIdList) {
    }

    public UserOperationMsgEvent processMsgEvent(String token, List<UserOperationRecordDTO> newTakeUpUserList, String msgType, String msgCategory) {
        return new UserOperationMsgEvent();
    }

    protected List<UserOperationRecordDTO> getTakeUpUser(Map<String, Object> params) {
        if (MapUtils.isEmpty(params)) {
            return Collections.emptyList();
        }
        params.put("takeUp", "1");
        return this.userOperationRecordMapper.queryEffectiveRecords(params);
    }

    protected QueryWrapper<UserOperationRecordDTO> getWrapper(Map<String, Object> params) {
        QueryWrapper queryWrapper = new QueryWrapper();
        params.forEach((arg_0, arg_1) -> ((QueryWrapper)queryWrapper).eq(arg_0, arg_1));
        return queryWrapper;
    }

    protected Map<String, Object> buildParams(AuthoredUser authoredUser, UserPageModelBodyDTO pageModelBodyDTO) {
        return Maps.newHashMap();
    }

    protected Map<String, Object> buildCheckNoTakeUpParams(UserOperationRecordDTO authoredUser) {
        return Maps.newHashMap();
    }

    protected boolean recordTakeUpOperation(List<UserOperationRecordDTO> newTakeUpUserList, List<UserOperationRecordDTO> takeUpUserList) {
        if (CollectionUtils.isEmpty(newTakeUpUserList)) {
            return false;
        }
        if (CollectionUtils.isEmpty(takeUpUserList)) {
            this.userOperationRecordMapper.batchInsertTakeUpRecords(newTakeUpUserList);
            return true;
        }
        ArrayList addTakeUpRecordList = new ArrayList();
        newTakeUpUserList.forEach(newTakeUpUser -> {
            List<UserOperationRecordDTO> occupiedRecords = takeUpUserList.stream().filter(takeUpUser -> StringUtils.equals((String)newTakeUpUser.getBusinessKey(), (String)takeUpUser.getBusinessKey())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(occupiedRecords)) {
                addTakeUpRecordList.add(newTakeUpUser);
            } else {
                occupiedRecords.forEach(conflictTakeUpRecord -> {
                    if (newTakeUpUser.getClientId().equals(conflictTakeUpRecord.getClientId())) {
                        this.userOperationRecordMapper.updateTime(conflictTakeUpRecord);
                    } else {
                        log.warn("takeUp fail,newTakeUpUser:{},conflictTakeUpRecord:{}", newTakeUpUser, conflictTakeUpRecord);
                    }
                });
            }
        });
        if (CollectionUtils.isNotEmpty(addTakeUpRecordList)) {
            this.userOperationRecordMapper.batchInsertTakeUpRecords(addTakeUpRecordList);
            return true;
        }
        return false;
    }

    protected List<TakeUpRecordDTO> recordNoTakeUpOperation(UserOperationRecordDTO currentUser, List<UserOperationRecordDTO> takeUpRecords) {
        ArrayList<TakeUpRecordDTO> takeUpRecordDTOS = new ArrayList<TakeUpRecordDTO>();
        if (CollectionUtils.isEmpty(takeUpRecords)) {
            this.recordUserOperation(currentUser);
            return takeUpRecordDTOS;
        }
        Optional<UserOperationRecordDTO> currentUserTakeUpOpt = takeUpRecords.stream().filter(userOperationRecordDTO2 -> StringUtils.equals((String)currentUser.getClientId(), (String)userOperationRecordDTO2.getClientId())).findFirst();
        if (currentUserTakeUpOpt.isPresent()) {
            UserOperationRecordDTO takeUpUser = currentUserTakeUpOpt.get();
            takeUpUser.setUpdateTime(LocalDateTime.now());
            if (this.updateUserOperationRecord(takeUpUser) <= 0) {
                log.error("recordNoTakeUpOperation fail,userPageModeDTO\uff1a{}", (Object)JsonUtils.objectToString((Object)takeUpUser));
            }
        } else {
            this.recordUserOperation(currentUser);
        }
        takeUpRecords.forEach(item -> {
            TakeUpRecordDTO newItem = new TakeUpRecordDTO();
            BeanUtils.copyProperties((Object)item, (Object)newItem);
            takeUpRecordDTOS.add(newItem);
        });
        return takeUpRecordDTOS;
    }

    protected void recordUserOperation(UserOperationRecordDTO newUser) {
        List recordUsers = this.userOperationRecordMapper.selectList(this.getWrapper(this.buildCheckNoTakeUpParams(newUser)));
        if (CollectionUtils.isEmpty((Collection)recordUsers)) {
            this.userOperationRecordMapper.insert((Object)newUser);
        } else {
            recordUsers.forEach(recordUser -> {
                recordUser.setUpdateTime(newUser.getUpdateTime());
                this.userOperationRecordMapper.updateTime(recordUser);
            });
        }
    }

    protected List<UserOperationRecordDTO> queryEffectiveRecords(Map<String, Object> params) {
        return this.userOperationRecordMapper.queryEffectiveRecords(params);
    }

    protected int batchDeleteTakeUpUser(Map<String, Object> params) {
        params.put("takeUp", "1");
        return this.userOperationRecordMapper.batchDeleteTakeUpUser(params);
    }

    protected void batchDeleteUserUserOperation(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        this.userOperationRecordMapper.deleteBatchIds(idList);
    }

    protected void deleteUserUserOperationById(long id) {
        this.userOperationRecordMapper.deleteById((Serializable)Long.valueOf(id));
    }

    protected int updateUserOperationRecord(UserOperationRecordDTO userPageModeDTO) {
        return this.userOperationRecordMapper.updateUserOperationRecord(userPageModeDTO);
    }
}

