package com.digiwin.athena.base.application.config;

import com.github.pagehelper.PageInterceptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Properties;

/**
 * MyBatis插件
 *
 * @author zhouxiao
 * @date 2019/5/10
 */
@Configuration
public class MybatisPluginAutoConfiguration {

    @Value("${pagehelper.helper-dialect}")
    private String helperDialect;
    @Value("${pagehelper.reasonable}")
    private String reasonable;
    @Value("${pagehelper.support-methods-arguments:}")
    private String supportMethodsArguments;
    @Value("${pagehelper.params}")
    private String params;

    @Bean
    public PageInterceptor pageInterceptor() {
        PageInterceptor interceptor = new PageInterceptor();
        Properties properties = new Properties();
        properties.setProperty("helperDialect", helperDialect);
        properties.setProperty("reasonable", reasonable);
        properties.setProperty("supportMethodsArguments", supportMethodsArguments);
        properties.setProperty("params", params);
        interceptor.setProperties(properties);
        return interceptor;
    }
}
