package com.digiwin.athena.base.application.service.commonused;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.application.meta.dto.commonused.SystemMenuDTO;
import com.digiwin.athena.base.application.meta.request.commonused.MenuAuthorityReq;
import com.digiwin.athena.base.application.meta.response.commonused.MenuAuthorityResp;
import com.digiwin.athena.base.application.meta.response.commonused.MenuQueryResp;
import com.digiwin.athena.base.application.meta.response.commonused.MenuTopResp;
import com.digiwin.athena.base.application.meta.response.commonused.MenuUnFoldResp;

import java.util.List;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2022/02/09 09:28:19
 */
public interface MenuService {


    /**
     * 查询用户置顶的模块信息
     *
     * @param user     用户信息
     * @param moduleNo 模块信息baseEntry：基础资料，report：报表 guess:猜你想去
     * @return 置顶的模块信息
     */
    boolean setMenuTop(AuthoredUser user, String moduleNo);


    /**
     * 查询用户置顶的模块信息
     *
     * @param user     用户信息
     * @param moduleNo 模块信息baseEntry：基础资料，report：报表 guess:猜你想去
     * @return 置顶的模块信息
     */
    boolean setMenuUnfold(AuthoredUser user, String moduleNo, Integer flag);

    /**
     * 查询用户置顶的模块信息
     *
     * @param user 用户信息
     * @return 置顶的模块信息
     */
    List<MenuTopResp> menuTopQuery(AuthoredUser user);

    /**
     * 查询用户模块展开、收起信息
     *
     * @param user 用户信息
     * @return 置顶的模块信息
     */
    List<MenuUnFoldResp> menuUnfoldQuery(AuthoredUser user);


    /**
     * 查询用户的模块信息
     *
     * @param user 用户信息
     * @return 置顶的模块信息
     */
    MenuQueryResp query(AuthoredUser user);

    /**
     * 获取所有系统菜单
     *
     * @return
     */
    List<SystemMenuDTO> getAllSystemMenus();

    /**
     * 用户级权限的菜单
     *
     * @param user
     * @return
     */
    List<MenuAuthorityResp> getAuthorityMenu(AuthoredUser user);


    /**
     * 用户级权限的菜单
     *
     * @param user
     * @return
     */
    List<MenuAuthorityResp> getAuthorityMenu(AuthoredUser user, List<MenuAuthorityReq> menuList);
}
