package com.digiwin.athena.base.application.service.userdefined;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.base.application.meta.request.userdefined.AgileReportUserDefineDTO;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.meta.po.userdefined.mongo.UserDefineData;
import com.digiwin.athena.base.infrastructure.mongo.AgileReportUserDefineMongoMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;

@Service
public class AgileReportUserDefineServiceImpl implements AgileReportUserDefineService {

    private Logger logger = LoggerFactory.getLogger(AgileReportUserDefineServiceImpl.class);

    @Autowired
    AgileReportUserDefineMongoMapper agileReportUserDefineMongoMapper;

    @Resource
    private MessageUtils messageUtils;

    @Override
    public void save(String userId, String tenantId, AgileReportUserDefineDTO userDefineDTO) {
        logger.info("[UserDefineServiceImpl.save],userId is" + userId +
                "tenantId is"+tenantId+"userDefineDTO is" + userDefineDTO);

        if (!ObjectUtils.isEmpty(userDefineDTO)) {
            UserDefineData userDefineData = new UserDefineData();

           if (StringUtils.isEmpty(userId) || StringUtils.isEmpty(tenantId) || StringUtils.isEmpty(userDefineDTO.getSnapshotId()) ||
                   userDefineDTO.getDashboard().isEmpty()) {
               throw AudcErrorCodeEnum.EMPTY_STRING_ERROR.getBusinessException(messageUtils.getMessage("exception.empty.strings.error"));
           } else {
               userDefineData.setUserId(userId);
               userDefineData.setTenantId(tenantId);
               userDefineData.setSnapshotId(userDefineDTO.getSnapshotId());
               userDefineData.setDashboard(userDefineDTO.getDashboard());
           }
            //TODO 先通过快照ID+用户+租户，从mongo查询出是否存在记录
            //TODO 如果不存在记录，使用MONGO的save方法进行数据存储，否则使用Mongo的update方法，更新时间/dashboard，更新条件为快照ID+用户+租户
            agileReportUserDefineMongoMapper.save(userDefineData);
        }
    }

    @Override
    public List<UserDefineData> getUserDefine(String snapshotId, String userId, String tenantId) {
        return agileReportUserDefineMongoMapper.getUserDefine(snapshotId,userId,tenantId);
    }
}

