/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.commonused;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.meta.dto.commonused.DataMigrationDto;
import com.digiwin.athena.base.application.service.commonused.DataMigrationService;
import com.digiwin.athena.base.infrastructure.config.EnvProperties;
import com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed.CategoryMapper;
import com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed.ItemLogMapper;
import com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed.ItemMapper;
import com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed.MenuTopMapper;
import com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed.MenuUnfoldMapper;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.ItemLogData;
import java.text.MessageFormat;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DataMigrationServiceImpl
implements DataMigrationService {
    private static final Logger log = LogManager.getLogger(DataMigrationServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    @Qualifier(value="baseAudcSqlSessionFactory")
    private SqlSessionFactory sqlSessionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="baseAudcDataSourceTransactionManager")
    public ResponseEntity<?> insertAllCommonUserData() {
        DataMigrationDto dataMigrationDto = this.queryAllCommonUserData();
        if (dataMigrationDto == null) {
            return ResponseEntityWrapper.wrapperOk((Object)"\u8bbf\u95eeatmc\u83b7\u53d6\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        SqlSession sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
        CategoryMapper categoryMapper = (CategoryMapper)sqlSession.getMapper(CategoryMapper.class);
        ItemMapper itemMapper = (ItemMapper)sqlSession.getMapper(ItemMapper.class);
        ItemLogMapper itemLogMapper = (ItemLogMapper)sqlSession.getMapper(ItemLogMapper.class);
        MenuTopMapper menuTopMapper = (MenuTopMapper)sqlSession.getMapper(MenuTopMapper.class);
        MenuUnfoldMapper menuUnfoldMapper = (MenuUnfoldMapper)sqlSession.getMapper(MenuUnfoldMapper.class);
        boolean successFlag = false;
        try {
            dataMigrationDto.getCategoryDatas().forEach(arg_0 -> ((CategoryMapper)categoryMapper).insert(arg_0));
            dataMigrationDto.getItemDatas().forEach(arg_0 -> ((ItemMapper)itemMapper).insert(arg_0));
            dataMigrationDto.getMenuTopDatas().forEach(arg_0 -> ((MenuTopMapper)menuTopMapper).insert(arg_0));
            dataMigrationDto.getMenuUnfoldDatas().forEach(arg_0 -> ((MenuUnfoldMapper)menuUnfoldMapper).insert(arg_0));
            List<ItemLogData> itemLogDatas = dataMigrationDto.getItemLogDatas();
            for (int i = 0; i < itemLogDatas.size(); ++i) {
                itemLogMapper.insert((Object)itemLogDatas.get(i));
                if ((i + 1) % 1000 != 0 && i != itemLogDatas.size() - 1) continue;
                sqlSession.commit();
                sqlSession.clearCache();
            }
            successFlag = true;
        }
        catch (Exception e) {
            log.error("\u63d2\u5165\u6570\u636e\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            sqlSession.close();
        }
        String message = MessageFormat.format("commom_category\u5927\u5c0f\u4e3a\uff1a{0}\uff0ccommom_item\u5927\u5c0f\u4e3a\uff1a{1}\uff0ccommom_item_log\u5927\u5c0f\u4e3a\uff1a{2}, common_menu_top\u5927\u5c0f\u4e3a\uff1a{3}, common_menu_unfold\u5927\u5c0f\u4e3a\uff1a{4}, isSuccess\uff1a{5}", dataMigrationDto.getCategoryDatas().size(), dataMigrationDto.getItemDatas().size(), dataMigrationDto.getItemLogDatas().size(), dataMigrationDto.getMenuTopDatas().size(), dataMigrationDto.getMenuUnfoldDatas().size(), Boolean.toString(successFlag));
        return ResponseEntityWrapper.wrapperOk((Object)message);
    }

    private DataMigrationDto queryAllCommonUserData() {
        String url = this.envProperties.getAtmcUri() + "api/amtc/v1/commonUsed/dataMigration/query";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<DataMigrationDto>>(){}, new Object[0]);
        return ((BaseResultDTO)responseEntity.getBody()).getResponse() != null ? (DataMigrationDto)((BaseResultDTO)responseEntity.getBody()).getResponse() : null;
    }
}

