/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.usermeta;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.application.meta.request.usermeta.UserMetadataItemReqDTO;
import com.digiwin.athena.base.application.meta.response.usermeta.UserMetadataItemRespDTO;
import com.digiwin.athena.base.application.service.usermeta.UserMetadataService;
import com.digiwin.athena.base.infrastructure.manager.iam.service.BaseIamService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserMetadataServiceImpl
implements UserMetadataService {
    private static final Logger log = LoggerFactory.getLogger(UserMetadataServiceImpl.class);
    private BaseIamService baseIamService;

    public UserMetadataServiceImpl(BaseIamService baseIamService) {
        this.baseIamService = baseIamService;
    }

    @Override
    public List<UserMetadataItemRespDTO> queryBatchUserMessageSendType(UserMetadataItemReqDTO messageSendTypeReq, AuthoredUser authoredUser) {
        String tenantSid;
        ArrayList<String> userIds = new ArrayList<String>(null != messageSendTypeReq.getUserIds() ? messageSendTypeReq.getUserIds() : Lists.newArrayList());
        CollUtil.removeBlank(userIds);
        if (CollUtil.isEmpty(userIds)) {
            userIds.add(authoredUser.getUserId());
        }
        if (StringUtils.isBlank((String)(tenantSid = messageSendTypeReq.getTenantSid()))) {
            tenantSid = String.valueOf(authoredUser.getTenantSid());
        }
        List userMetadataItems = this.baseIamService.batchQueryUserMetadataItem(userIds, tenantSid, "MessageSendType", "basic");
        Map userMetadataItemMap = userMetadataItems.stream().collect(Collectors.toMap(map -> MapUtil.getStr((Map)map, (Object)"userId", (String)""), Function.identity(), (oldValue, newValue) -> oldValue));
        ArrayList resultList = Lists.newArrayList();
        for (String userId : userIds) {
            Map metadataItem = (Map)userMetadataItemMap.get(userId);
            String msgSendTypeVal = MapUtil.getStr((Map)metadataItem, (Object)"value", (String)"im");
            resultList.add(UserMetadataItemRespDTO.builder().userId(userId).value(msgSendTypeVal).build());
        }
        return resultList;
    }
}

