package com.digiwin.athena.base.application.schedule;

import com.digiwin.athena.base.application.service.commonused.ItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @description:
 * @author: dongwh
 * @date: 2022/6/16 09:33
 */
@Component
public class CommonUsedSchedule {

    // 定时任务，每天凌晨0点执行一次
    private static final String CLEAR_ITEM_LOG_CORN = "0 0 0 * * ?";

    @Autowired
    private ItemService itemService;

    /**
     * 定时任务：每天凌晨0点删除一周前的数据
     */
    @Scheduled(cron = CLEAR_ITEM_LOG_CORN)
    public void clearItemLogDataWeeksAgo() {
        // 保留 common_item_log 一周的数据，不包含当天
        itemService.deleteItemLogByCreateTime(1);
    }
}
