/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.eventbus.subscriber;

import com.digiwin.athena.base.application.eventbus.event.MessageAgentChangeBatchEvent;
import com.digiwin.athena.base.application.eventbus.event.MessageAgentChangeEvent;
import com.digiwin.athena.base.application.eventbus.event.MessageAgentClearBatchEvent;
import com.digiwin.athena.base.application.eventbus.event.MessageAgentClearEvent;
import com.digiwin.athena.base.application.meta.request.proxyinfo.ProxyInfoSaveReq;
import com.digiwin.athena.base.infrastructure.manager.atmc.BaseAtmcService;
import com.digiwin.athena.base.infrastructure.manager.atmc.dto.NoticeProxyInfoDTO;
import com.digiwin.athena.base.infrastructure.manager.eoc.BaseEocService;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MessageAgentChangeSubscriber {
    private static final Logger log = LoggerFactory.getLogger(MessageAgentChangeSubscriber.class);
    @Resource
    private BaseAtmcService baseAtmcService;
    @Resource
    private BaseEocService eocService;

    @Subscribe
    public void messageAgentChange(MessageAgentChangeEvent event) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", event.getUserId());
        param.put("agentId", event.getAgentId());
        param.put("agentBeginDate", event.getAgentBeginDate());
        param.put("agentEndDate", event.getAgentEndDate());
        this.baseAtmcService.messageAgentChange(param, event.getToken());
    }

    @Subscribe
    public void messageAgentClear(MessageAgentClearEvent event) {
        this.baseAtmcService.messageAgentClear(event.getUserId(), event.getToken());
    }

    @Subscribe
    public void messageAgentBatchChange(MessageAgentChangeBatchEvent event) {
        ArrayList<NoticeProxyInfoDTO> list = new ArrayList<NoticeProxyInfoDTO>();
        for (ProxyInfoSaveReq proxyInfoSaveReq : event.getList()) {
            NoticeProxyInfoDTO dto = new NoticeProxyInfoDTO();
            dto.setAgentId(proxyInfoSaveReq.getAgentId());
            dto.setAgentName(proxyInfoSaveReq.getAgentName());
            dto.setPrincipalId(proxyInfoSaveReq.getUserId());
            dto.setPrincipalName(proxyInfoSaveReq.getUserName());
            dto.setStartDate(proxyInfoSaveReq.getAgentBeginDate());
            dto.setEndDate(proxyInfoSaveReq.getAgentEndDate());
            list.add(dto);
        }
        this.baseAtmcService.messageAgentBatchChange(list, event.getToken());
    }

    @Subscribe
    public void messageAgentClearBatchEvent(MessageAgentClearBatchEvent event) {
        if (CollectionUtils.isNotEmpty(event.getUserList())) {
            event.getUserList().forEach(userId -> {
                this.eocService.empAgentClear(userId, event.getUser());
                this.baseAtmcService.messageAgentClear(userId, event.getUser().getToken());
            });
        }
    }
}

