/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.cofw;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.base.application.service.cofw.CofwService;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.manager.atmc.BaseAtmcService;
import com.digiwin.athena.base.infrastructure.manager.atmc.dto.VerifyAppPermissionDTO;
import com.digiwin.athena.base.infrastructure.manager.atmc.dto.VerifyAppPermissionReq;
import com.digiwin.athena.base.infrastructure.mapper.audc.cofw.CofwMapper;
import com.digiwin.athena.base.infrastructure.meta.po.cofw.Cofw;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CofwServiceImpl
implements CofwService {
    private static final Logger log = LoggerFactory.getLogger(CofwServiceImpl.class);
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private BaseAtmcService baseAtmcService;
    private static final String ATHENA_TABLE = "ATHENA_TABLE";
    private static final List<String> hiddenToolbarComponentType = Lists.newArrayList((Object[])new String[]{"TABLE", "GRID_TABLE", "ATHENA_TABLE", "GROUP_ORDER"});
    public static final int COFW_TYPE_0 = 0;
    public static final int COFW_TYPE_1 = 1;
    public static final int COFW_TYPE_2 = 2;
    private static final String STR_COFW_TYPE_2 = "2";
    @Autowired
    private CofwMapper cofwMapper;

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public void save(AuthoredUser user, JSONObject cofwSaveBody) {
        try {
            if (cofwSaveBody != null) {
                String businessId = cofwSaveBody.getString("businessId");
                String cofwType = cofwSaveBody.getString("cofwType");
                String cofwName = cofwSaveBody.getString("cofwName");
                JSONObject cofwContent = cofwSaveBody.getJSONObject("cofwContent");
                Cofw cofw = new Cofw();
                if (cofwContent != null) {
                    JSONObject cofwMark;
                    cofw.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
                    cofw.setUserId(user.getUserId());
                    cofw.setUserName(user.getUserName());
                    cofw.setTenantId(user.getTenantId());
                    cofw.setCofwType(Integer.parseInt(cofwType));
                    cofw.setBusinessId(Long.parseLong(businessId));
                    cofw.setCofwName(cofwName);
                    cofw.setCreateTime(LocalDateTime.now());
                    if (cofwContent.containsKey((Object)"cofwMark") && (cofwMark = cofwContent.getJSONObject("cofwMark")) != null) {
                        cofw.setCofwMark((Object)cofwMark.toString());
                    }
                    if (!cofwType.equals(STR_COFW_TYPE_2)) {
                        if (cofwContent.containsKey((Object)"dynamicForm")) {
                            JSONObject dynamicForm = cofwContent.getJSONObject("dynamicForm");
                            if (dynamicForm != null) {
                                if (dynamicForm.containsKey((Object)"layout")) {
                                    dynamicForm.put((Object)"actions", (Object)new JSONArray());
                                    this.hiddenToolbar(dynamicForm);
                                }
                                cofw.setCofwContent((Object)dynamicForm.toString());
                            } else {
                                cofw.setCofwContent((Object)"");
                            }
                        }
                        this.cofwMapper.insert((Object)cofw);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Collection failed", (Throwable)e);
            throw AudcErrorCodeEnum.COFW_SAVE_FAILED.getBusinessException(this.messageUtils.getMessage("cofw.save.fail.mes"));
        }
    }

    private void hiddenToolbar(JSONObject dynamicForm) {
        JSONArray settingList = new JSONArray();
        JSONObject settingFixed = new JSONObject();
        settingList.add((Object)"composite-sort");
        settingList.add((Object)"setting");
        settingFixed.put((Object)"hideDefaultToolbar", (Object)settingList);
        settingFixed.put((Object)"type", (Object)ATHENA_TABLE);
        JSONArray layoutList = dynamicForm.getJSONArray("layout");
        this.hiddenToolbar(layoutList, settingFixed);
    }

    private void hiddenToolbar(JSONArray componentArr, JSONObject settingFixed) {
        if (CollectionUtils.isEmpty((Collection)componentArr)) {
            return;
        }
        for (int i = 0; i < componentArr.size(); ++i) {
            JSONObject component = componentArr.getJSONObject(i);
            String type = component.getString("type");
            if (!hiddenToolbarComponentType.contains(type)) continue;
            if (component.containsKey((Object)"detailModel")) {
                JSONArray detailModelArr = component.getJSONArray("detailModel");
                this.hiddenToolbar(detailModelArr, settingFixed);
            }
            component.put((Object)"editable", (Object)false);
            component.put((Object)"checkbox", (Object)false);
            component.put((Object)"disabledUserDefined", (Object)true);
            component.put((Object)"saveColumnsWidth", (Object)false);
            JSONObject settingInner = component.getJSONObject("setting");
            settingInner.putAll((Map)settingFixed);
        }
    }

    @Override
    public List<Cofw> getCofwList(AuthoredUser user) {
        List<Cofw> list = this.cofwMapper.getCofwList(user.getUserId(), user.getTenantId());
        list = this.filterNoAppPermissionData(list);
        return list;
    }

    private List<Cofw> filterNoAppPermissionData(List<Cofw> list) {
        ArrayList<Cofw> newCofwList = new ArrayList<Cofw>();
        if (CollectionUtils.isEmpty(list)) {
            return newCofwList;
        }
        Map<Integer, List<Cofw>> typeGroup = list.stream().collect(Collectors.groupingBy(Cofw::getCofwType));
        typeGroup.forEach((type, cofwList) -> {
            if (1 == type) {
                List<Long> projectIdList = cofwList.stream().map(Cofw::getBusinessId).distinct().collect(Collectors.toList());
                List<VerifyAppPermissionDTO> projectAppPermissioms = this.getAppPermissiom(1, projectIdList);
                this.filterCofwList((List<Cofw>)newCofwList, (List<Cofw>)cofwList, projectAppPermissioms);
            }
            if (0 == type) {
                List<Long> taskIdList = cofwList.stream().map(Cofw::getBusinessId).distinct().collect(Collectors.toList());
                List<VerifyAppPermissionDTO> taskAppPermissioms = this.getAppPermissiom(2, taskIdList);
                this.filterCofwList((List<Cofw>)newCofwList, (List<Cofw>)cofwList, taskAppPermissioms);
            }
        });
        return newCofwList;
    }

    private void filterCofwList(List<Cofw> newCofwList, List<Cofw> cofwList, List<VerifyAppPermissionDTO> projectAppPermissioms) {
        List businessIdList = projectAppPermissioms.stream().filter(VerifyAppPermissionDTO::getHasAppPermission).map(VerifyAppPermissionDTO::getBusinessId).distinct().collect(Collectors.toList());
        cofwList = cofwList.stream().filter(cofw -> businessIdList.contains(cofw.getBusinessId())).collect(Collectors.toList());
        newCofwList.addAll(cofwList);
    }

    private List<VerifyAppPermissionDTO> getAppPermissiom(int type, List<Long> businessIdList) {
        VerifyAppPermissionReq verifyAppPermissionReq = new VerifyAppPermissionReq();
        verifyAppPermissionReq.setType(Integer.valueOf(type));
        verifyAppPermissionReq.setBusinessIdList(businessIdList);
        return this.baseAtmcService.verifyAppPermission(verifyAppPermissionReq);
    }

    @Override
    public Cofw getOneCofwById(long id) {
        return this.cofwMapper.getOneCofwById(id);
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public void updateCofwById(Cofw cofw) {
        this.cofwMapper.updateById((Object)cofw);
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int deleteByTenant(String tenantId) {
        int result;
        QueryWrapper deleteWrapper = new QueryWrapper();
        deleteWrapper.eq((Object)"tenant_id", (Object)tenantId);
        try {
            result = this.cofwMapper.delete((Wrapper)deleteWrapper);
        }
        catch (Exception e) {
            log.error("Delete tenantId:[" + tenantId + "] error", (Throwable)e);
            return -1;
        }
        return result;
    }
}

