/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.importstatistics.service.helpler;

import cn.hutool.core.collection.CollectionUtil;
import com.digiwin.athena.atdm.cac.CommonCacService;
import com.digiwin.athena.atdm.cac.dto.UserAppDTO;
import com.digiwin.athena.base.infrastructure.manager.thememap.BaseThemeMapService;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.TmAppDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppPermissionUtil {
    private static final Logger log = LoggerFactory.getLogger(AppPermissionUtil.class);
    @Autowired
    private BaseThemeMapService themeMapService;
    @Autowired
    private CommonCacService cacService;

    public List<String> handleAppPermission(List<String> activityCodeList) {
        if (CollectionUtil.isEmpty(activityCodeList)) {
            return activityCodeList;
        }
        List userAppDTOS = this.cacService.qryUserApp();
        if (CollectionUtil.isEmpty((Collection)userAppDTOS)) {
            return new ArrayList<String>();
        }
        List userAppCodeList = userAppDTOS.stream().map(UserAppDTO::getId).distinct().collect(Collectors.toList());
        List tmAppDTOS = this.themeMapService.getAppInfoByCodeAndType("task", activityCodeList);
        Map<String, List<TmAppDTO>> codeAppRel = tmAppDTOS.stream().collect(Collectors.groupingBy(TmAppDTO::getCode));
        ArrayList<String> hasPermissionActivityCodeList = new ArrayList<String>();
        activityCodeList.forEach(activityCode -> {
            if (this.hasAppPermission((List)codeAppRel.get(activityCode), userAppCodeList)) {
                hasPermissionActivityCodeList.add((String)activityCode);
            }
        });
        return hasPermissionActivityCodeList;
    }

    private boolean hasAppPermission(List<TmAppDTO> tmAppList, List<String> appCodeList) {
        if (CollectionUtils.isEmpty(tmAppList)) {
            return false;
        }
        List appCodes = tmAppList.stream().map(TmAppDTO::getAppCode).distinct().collect(Collectors.toList());
        return CollectionUtil.containsAny(appCodeList, appCodes);
    }
}

