/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.userdefined;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.base.infrastructure.meta.po.userdefined.mongo.UserOperateRecordDTO;
import com.digiwin.athena.base.infrastructure.mongo.UserDefinedMongoMapper;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class UserOperateRecordService {
    private String COLLECTION_NAME = "userOperateRecord";
    @Autowired
    private UserDefinedMongoMapper userDefinedMongoMapper;

    public void save(UserOperateRecordDTO userOperateRecordDTO) {
        Query query = this.buildQuery(userOperateRecordDTO);
        if ("sort".equals(userOperateRecordDTO.getType())) {
            if (StringUtils.isBlank((String)userOperateRecordDTO.getCode())) {
                throw BusinessException.create((Integer)1006, (String)"Sort type code is not null");
            }
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"code").is((Object)userOperateRecordDTO.getCode()));
        }
        this.userDefinedMongoMapper.getUserDefinedMongoTemplate().remove(query, UserOperateRecordDTO.class, this.COLLECTION_NAME);
        this.userDefinedMongoMapper.getUserDefinedMongoTemplate().save((Object)userOperateRecordDTO, this.COLLECTION_NAME);
    }

    private Query buildQuery(UserOperateRecordDTO userOperateRecordDTO) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        userOperateRecordDTO.setUserId(authoredUser.getUserId());
        userOperateRecordDTO.setTenantId(authoredUser.getTenantId());
        userOperateRecordDTO.setCreateTime(new Date());
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userOperateRecordDTO.getUserId())).addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)userOperateRecordDTO.getTenantId())).addCriteria((CriteriaDefinition)Criteria.where((String)"pageCode").is((Object)userOperateRecordDTO.getPageCode())).addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)userOperateRecordDTO.getType()));
        return query;
    }

    public UserOperateRecordDTO findOne(UserOperateRecordDTO userOperateRecordDTO) {
        List<UserOperateRecordDTO> userOperateRecordDTOS = this.findList(userOperateRecordDTO);
        return CollectionUtils.isNotEmpty(userOperateRecordDTOS) ? userOperateRecordDTOS.get(0) : null;
    }

    public List<UserOperateRecordDTO> findList(UserOperateRecordDTO userOperateRecordDTO) {
        Query query = this.buildQuery(userOperateRecordDTO);
        query.fields().include("pageCode").include("code").include("type").include("records");
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"_id")}));
        return this.userDefinedMongoMapper.getUserDefinedMongoTemplate().find(query, UserOperateRecordDTO.class, this.COLLECTION_NAME);
    }
}

