/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.usertrack;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.base.application.meta.request.usertrack.AccountDTO;
import com.digiwin.athena.base.application.meta.request.usertrack.UserTrackSearchDTO;
import com.digiwin.athena.base.application.service.usertrack.UserTrackService;
import com.digiwin.athena.base.application.service.usertrack.analyzer.ReportDataAnalyzer;
import com.digiwin.athena.base.application.util.TimeUtils;
import com.digiwin.athena.base.infrastructure.constant.AudcErrorCodeEnum;
import com.digiwin.athena.base.infrastructure.meta.po.usertrack.mongo.UserTrackExtendDTO;
import com.digiwin.athena.base.infrastructure.mongo.UserTrackMongoMapper;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class UserTrackServiceImpl
implements UserTrackService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(UserTrackServiceImpl.class);
    @Autowired
    private List<ReportDataAnalyzer> reportDataAnalyzerList;
    private Map<String, ReportDataAnalyzer> reportDataAnalyzerMap = new HashMap<String, ReportDataAnalyzer>();
    @Resource
    private MessageUtils messageUtils;
    @Autowired
    private UserTrackMongoMapper userTrackMongoMapper;
    private static final String CLEAR_OPERATION_PURCHASE_WITH_DRAWING = "Athena01144";

    public void afterPropertiesSet() throws Exception {
        this.reportDataAnalyzerList.forEach(reportDataAnalyzer -> this.reportDataAnalyzerMap.put(StringUtils.upperCase((String)reportDataAnalyzer.getSourceType()), (ReportDataAnalyzer)reportDataAnalyzer));
    }

    @Override
    public void handleReportData(List<UserTrackExtendDTO> reportDataList) {
        if (CollectionUtils.isEmpty(reportDataList)) {
            return;
        }
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        if (null != authoredUser) {
            log.info("currentUser{}:{} start", (Object)authoredUser.getTenantId(), (Object)authoredUser.getUserId());
            log.info("currentUser{}:{} reportDataSize:{}", new Object[]{authoredUser.getTenantId(), authoredUser.getUserId(), reportDataList.size()});
        }
        this.regularReportData(reportDataList);
        Map<String, List<UserTrackExtendDTO>> reportDataMap = this.classifyReportData(reportDataList);
        reportDataMap.forEach((source, sourceReportDataList) -> {
            if (this.reportDataAnalyzerMap.containsKey(source) && CollectionUtils.isNotEmpty((Collection)sourceReportDataList)) {
                this.printReportLog((List<UserTrackExtendDTO>)sourceReportDataList);
                this.reportDataAnalyzerMap.get(source).analysis((List<UserTrackExtendDTO>)sourceReportDataList);
            } else {
                log.warn("unsupported source:{}, reportDataSize:{}", source, (Object)sourceReportDataList.size());
            }
        });
        if (null != authoredUser) {
            log.info("currentUser{}:{} end", (Object)authoredUser.getTenantId(), (Object)authoredUser.getUserId());
        }
    }

    private void printReportLog(List<UserTrackExtendDTO> reportDataList) {
        int count = 0;
        int countThreshold = 10;
        StringBuilder sb = new StringBuilder();
        for (UserTrackExtendDTO userTrack : reportDataList) {
            if (null == userTrack) continue;
            sb.append(userTrack.printInfo());
            if (++count % countThreshold != 0) continue;
            log.info("{}", (Object)sb.toString());
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            log.info("{}", (Object)sb.toString());
        }
    }

    private void regularReportData(List<UserTrackExtendDTO> reportDataList) {
        LocalDateTime createTime = LocalDateTime.now();
        long createDate = TimeUtils.date2Long(createTime);
        String createDateStr = com.digiwin.athena.appcore.util.TimeUtils.format((LocalDateTime)createTime, (String)"yyyy-MM-dd HH:mm:ss");
        reportDataList.stream().forEach(reportData -> {
            reportData.setCreateDate(Long.valueOf(createDate));
            reportData.setCreateDateStr(createDateStr);
            reportData.setUniqueId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        });
    }

    private Map<String, List<UserTrackExtendDTO>> classifyReportData(List<UserTrackExtendDTO> reportDataList) {
        if (CollectionUtils.isEmpty(reportDataList)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<UserTrackExtendDTO>> reportDataMap = new HashMap<String, List<UserTrackExtendDTO>>();
        for (UserTrackExtendDTO reportData : reportDataList) {
            String sourceType = StringUtils.isNotBlank((String)reportData.getSource()) ? reportData.getSource() : "userTrack_analyzer";
            List sourceReportDataList = reportDataMap.computeIfAbsent(StringUtils.upperCase((String)sourceType), source -> new ArrayList());
            sourceReportDataList.add(reportData);
        }
        return reportDataMap;
    }

    @Override
    public void clearReportData(AccountDTO account) {
        if (!StringUtils.equals((String)account.getPassword(), (String)CLEAR_OPERATION_PURCHASE_WITH_DRAWING)) {
            throw AudcErrorCodeEnum.INVALID_REQUEST_PARAM.getBusinessException(this.messageUtils.getMessage("exception.password.error"));
        }
        this.reportDataAnalyzerList.forEach(ReportDataAnalyzer::clear);
    }

    @Override
    public Map<String, Object> findByParam(UserTrackSearchDTO searchDTO, AuthoredUser user) {
        log.info("UserTrackServiceImpl-findByParam-searchDTO:{}", (Object)JsonUtils.objectToString((Object)searchDTO));
        log.info("UserTrackServiceImpl-findByParam-user:{}", (Object)JsonUtils.objectToString((Object)user));
        String tenantId = searchDTO.getTenantId();
        if (StringUtils.isEmpty((String)tenantId)) {
            tenantId = user.getTenantId();
        }
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        if (StringUtils.isNotBlank((String)searchDTO.getUserId())) {
            criteria.and("userId").is((Object)searchDTO.getUserId());
        }
        if (StringUtils.isNotBlank((String)searchDTO.getWorkCode())) {
            criteria.and("workCode").is((Object)searchDTO.getWorkCode());
        }
        if (StringUtils.isNotBlank((String)searchDTO.getWorkType())) {
            criteria.and("workType").is((Object)searchDTO.getWorkType());
        }
        if (CollectionUtils.isNotEmpty(searchDTO.getOperations())) {
            criteria.and("operation").in(searchDTO.getOperations());
        }
        String startTime = searchDTO.getStartTime();
        String endTime = searchDTO.getEndTime();
        this.validStartEndTime(startTime, endTime);
        if (StringUtils.isNotBlank((String)startTime) && StringUtils.isNotBlank((String)endTime)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"createDateStr").gte((Object)startTime), Criteria.where((String)"createDateStr").lte((Object)endTime)});
        } else if (StringUtils.isNotBlank((String)searchDTO.getStartTime())) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"createDateStr").gte((Object)startTime)});
        } else if (StringUtils.isNotBlank((String)searchDTO.getEndTime())) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"createDateStr").lte((Object)endTime)});
        }
        Query query = Query.query((CriteriaDefinition)criteria);
        query.fields().exclude("orgs").exclude("empInfo").exclude("workContent").exclude("attachData");
        List list = this.userTrackMongoMapper.findByParam(tenantId + "_track", query);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("count", list.size());
        resultMap.put("datas", list);
        return resultMap;
    }

    private void validStartEndTime(String startTime, String endTime) {
        if (StringUtils.isNotBlank((String)startTime) && !this.validTimeFormat(startTime, "yyyy-MM-dd HH:mm:ss")) {
            throw AudcErrorCodeEnum.INVALID_REQUEST_PARAM.getBusinessException("The format of the startTime is incorrect! The correct is yyyy-MM-dd HH:mm:ss");
        }
        if (StringUtils.isNotBlank((String)endTime) && !this.validTimeFormat(endTime, "yyyy-MM-dd HH:mm:ss")) {
            throw AudcErrorCodeEnum.INVALID_REQUEST_PARAM.getBusinessException("The format of the endTime is incorrect! The correct is yyyy-MM-dd HH:mm:ss");
        }
    }

    private boolean validTimeFormat(String time, String format) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
            simpleDateFormat.parse(time);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

