package com.digiwin.athena.base.application.service.action;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.action.executor.DataSubmissionService;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.mongodb.CommonMongodbService;
import com.digiwin.athena.atdm.uibot.CommonUiBotService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.digiwin.athena.atdm.action.constant.CallbackConstants.API_NAME;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.ASA_CALLBACK_PARAMETER;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.ASA_CALLBACK_STD_DATA;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.ASA_INTENT_PROCESS;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.ASA_OUTPUT_DATA;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.PRODUCT;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.PRODUCT_ASA;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.PROJECT_DEF_CODE;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.PTM_BACKLOG_ID;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.REQ_ID;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.TASK_DEF_CODE;

@Slf4j
@Service
public class AsaCallbackService {

    @Autowired
    private CommonMongodbService commonMongodbService;

    @Autowired(required = false)
    @Qualifier("espRequestWorkItemTemplate")
    private MongoTemplate espRequestWorkItemTemplate;

    @Autowired
    private CommonAtmcService atmcService;

    @Autowired
    private CommonUiBotService commonUiBotService;

    @Autowired
    private DataSubmissionService dataSubmissionService;

    private MongoTemplate getEspRequestWorkItemTemplate() {
        if (null != espRequestWorkItemTemplate) {
            return espRequestWorkItemTemplate;
        }
        throw BusinessException.create("创建espRequestWorkItemTemplate失败，请检查数据源配置是否正确~");
    }

    /**
     * 判断是否是ASA回调
     * @return
     */
    public Map<String, Object> getAsaRequest(String reqId, AuthoredUser user) {
        Map asaRequestMap = new HashMap();
        // 查询条件
        Query query = Query.query(Criteria.where(REQ_ID).is(reqId).and(PRODUCT).is(PRODUCT_ASA).and(API_NAME).is(ASA_INTENT_PROCESS));
        // 查询asa请求
        List<Map> asaRequestList = commonMongodbService.query(getEspRequestWorkItemTemplate(), user.getTenantId(), query);
        if (CollectionUtils.isNotEmpty(asaRequestList)) {
            asaRequestMap = asaRequestList.get(0);
        }
        return asaRequestMap;
    }

    /**
     * 执行
     */
    public void executeAction(String data, Map<String, Object> requestMap, AuthoredUser user) {
        if (!requestMap.containsKey(PTM_BACKLOG_ID) || null == requestMap.get(PTM_BACKLOG_ID)) {
            throw BusinessException.create("缺少" + PTM_BACKLOG_ID);
        }
        // 任务卡id
        String backlogId = requestMap.get(PTM_BACKLOG_ID).toString();
        // 任务code
        String taskDefCode = requestMap.get(TASK_DEF_CODE).toString();
        // 项目code
        String projectDefCode = requestMap.get(PROJECT_DEF_CODE).toString();

        // 业务数据
        Map outputDataMap = null;
        // 回调反参
        Map<String, Object> dataMap = JsonUtils.jsonToObject(data, Map.class);
        if (dataMap.containsKey(ASA_CALLBACK_STD_DATA) && null != dataMap.get(ASA_CALLBACK_STD_DATA)) {
            Map stdDataMap = JsonUtils.jsonToObject(JsonUtils.objectToString(dataMap.get(ASA_CALLBACK_STD_DATA)), Map.class);
            if (stdDataMap.containsKey(ASA_CALLBACK_PARAMETER) && null != stdDataMap.get(ASA_CALLBACK_PARAMETER)) {
                Map paramMap = JsonUtils.jsonToObject(JsonUtils.objectToString(stdDataMap.get(ASA_CALLBACK_PARAMETER)), Map.class);
                if (paramMap.containsKey(ASA_OUTPUT_DATA) && null != paramMap.get(ASA_OUTPUT_DATA)) {
                    outputDataMap = JsonUtils.jsonToObject(JsonUtils.objectToString(paramMap.get(ASA_OUTPUT_DATA)), Map.class);
                }
            }
        }
        log.error("AsaCallbackService-outputDataMap:{}", JsonUtils.objectToString(outputDataMap));
        // 获取任务信息
        Map activityData = atmcService.getTaskData(backlogId, false);
        log.error("AsaCallbackService-activityData:{}", JsonUtils.objectToString(activityData));
        // 获取submitAction
        List<SubmitAction> submitActions = commonUiBotService.getTaskPageSubmitActions(projectDefCode, taskDefCode, activityData);
        if (CollectionUtils.isEmpty(submitActions)) {
            throw BusinessException.create("未获取到submitAction");
        }
        SubmitAction submitAction = submitActions.get(0);
        // 将执行人类型变更为999
        updateBpmUserParams(submitAction, user, 999);
        log.error("AsaCallbackService-submitAction:{}", JsonUtils.objectToString(submitAction));
        // 执行submitAction
        dataSubmissionService.submit(submitAction.getExecuteContext(), submitAction, outputDataMap);
        log.error("AsaCallbackService-提交成功!:{}", JsonUtils.objectToString(submitAction));
    }



    private void updateBpmUserParams(SubmitAction action, AuthoredUser user,Integer performerType) {
        if (action.getParas() != null) {
            Map bpmParas = action.getParas();
            if (bpmParas.containsKey("performerType")) {
                bpmParas.put("performerType", performerType);
            }

        }
        //循环遍历子节点信息
        List<SubmitAction> attachActions = action.getAttachActions();
        if (CollectionUtils.isNotEmpty(attachActions)) {
            for (SubmitAction attachAction : attachActions) {
                updateBpmUserParams(attachAction, user,performerType);
            }
        }

    }



}
