package com.digiwin.athena.base.application.service.usertrack.analyzer;

import com.digiwin.athena.base.infrastructure.meta.po.usertrack.mongo.UserTrackExtendDTO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 功能分析器
 *
 * @author majianfu
 * @date 2022/6/8
 * @since
 */
@Service
public class FunctionAnalyzer extends AbstractReportDataAnalyzer {
    private static final String FUNCTION_ANALYSIS = "function_analysis";

    /**
     * {@inheritDoc}
     */
    @Override
    public String getSourceType() {
        return FUNCTION_ANALYSIS;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void analysis(List<UserTrackExtendDTO> reportDataList) {
        this.userTrackMapper.safeSaveData(FUNCTION_ANALYSIS, reportDataList);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void clear() {
        userTrackMapper.dropCollection(FUNCTION_ANALYSIS);
    }
}
