/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.action;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.action.executor.DataSubmissionService;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.mongodb.CommonMongodbService;
import com.digiwin.athena.atdm.uibot.CommonUiBotService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class AsaCallbackService {
    private static final Logger log = LoggerFactory.getLogger(AsaCallbackService.class);
    @Autowired
    private CommonMongodbService commonMongodbService;
    @Autowired(required=false)
    @Qualifier(value="espRequestWorkItemTemplate")
    private MongoTemplate espRequestWorkItemTemplate;
    @Autowired
    private CommonAtmcService atmcService;
    @Autowired
    private CommonUiBotService commonUiBotService;
    @Autowired
    private DataSubmissionService dataSubmissionService;

    private MongoTemplate getEspRequestWorkItemTemplate() {
        if (null != this.espRequestWorkItemTemplate) {
            return this.espRequestWorkItemTemplate;
        }
        throw BusinessException.create((String)"\u521b\u5efaespRequestWorkItemTemplate\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u914d\u7f6e\u662f\u5426\u6b63\u786e~");
    }

    public Map<String, Object> getAsaRequest(String reqId, AuthoredUser user) {
        Map<String, Object> asaRequestMap = new HashMap<String, Object>();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"reqId").is((Object)reqId).and("product").is((Object)"ASA").and("apiName").is((Object)"asa.intent.process"));
        List asaRequestList = this.commonMongodbService.query(this.getEspRequestWorkItemTemplate(), user.getTenantId(), query);
        if (CollectionUtils.isNotEmpty((Collection)asaRequestList)) {
            asaRequestMap = (Map)asaRequestList.get(0);
        }
        return asaRequestMap;
    }

    public void executeAction(String data, Map<String, Object> requestMap, AuthoredUser user) {
        Map paramMap;
        Map stdDataMap;
        if (!requestMap.containsKey("ptmBacklogId") || null == requestMap.get("ptmBacklogId")) {
            throw BusinessException.create((String)"\u7f3a\u5c11ptmBacklogId");
        }
        String backlogId = requestMap.get("ptmBacklogId").toString();
        String taskDefCode = requestMap.get("taskDefCode").toString();
        String projectDefCode = requestMap.get("projectDefCode").toString();
        Map outputDataMap = null;
        Map dataMap = (Map)JsonUtils.jsonToObject((String)data, Map.class);
        if (dataMap.containsKey("std_data") && null != dataMap.get("std_data") && (stdDataMap = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString(dataMap.get("std_data")), Map.class)).containsKey("parameter") && null != stdDataMap.get("parameter") && (paramMap = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString(stdDataMap.get("parameter")), Map.class)).containsKey("output_data") && null != paramMap.get("output_data")) {
            outputDataMap = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString(paramMap.get("output_data")), Map.class);
        }
        log.error("AsaCallbackService-outputDataMap:{}", (Object)JsonUtils.objectToString(outputDataMap));
        Map activityData = this.atmcService.getTaskData(backlogId, Boolean.valueOf(false));
        log.error("AsaCallbackService-activityData:{}", (Object)JsonUtils.objectToString((Object)activityData));
        List submitActions = this.commonUiBotService.getTaskPageSubmitActions(projectDefCode, taskDefCode, activityData);
        if (CollectionUtils.isEmpty((Collection)submitActions)) {
            throw BusinessException.create((String)"\u672a\u83b7\u53d6\u5230submitAction");
        }
        SubmitAction submitAction = (SubmitAction)submitActions.get(0);
        this.updateBpmUserParams(submitAction, user, 999);
        log.error("AsaCallbackService-submitAction:{}", (Object)JsonUtils.objectToString((Object)submitAction));
        this.dataSubmissionService.submit(submitAction.getExecuteContext(), submitAction, outputDataMap);
        log.error("AsaCallbackService-\u63d0\u4ea4\u6210\u529f!:{}", (Object)JsonUtils.objectToString((Object)submitAction));
    }

    private void updateBpmUserParams(SubmitAction action, AuthoredUser user, Integer performerType) {
        List attachActions;
        Map bpmParas;
        if (action.getParas() != null && (bpmParas = action.getParas()).containsKey("performerType")) {
            bpmParas.put("performerType", performerType);
        }
        if (CollectionUtils.isNotEmpty((Collection)(attachActions = action.getAttachActions()))) {
            for (SubmitAction attachAction : attachActions) {
                this.updateBpmUserParams(attachAction, user, performerType);
            }
        }
    }
}

