/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.commonused;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.base.application.converter.DataConverter;
import com.digiwin.athena.base.application.meta.dto.commonused.TmDataListDTO;
import com.digiwin.athena.base.application.meta.dto.commonused.TmDataTierListDTO;
import com.digiwin.athena.base.application.meta.request.commonused.BatchSortItemReq;
import com.digiwin.athena.base.application.meta.request.permission.TypeActivities;
import com.digiwin.athena.base.application.meta.request.permission.TypeActivitiesAccessible;
import com.digiwin.athena.base.application.meta.response.commonused.CateAndItemResp;
import com.digiwin.athena.base.application.meta.response.commonused.CategoryResp;
import com.digiwin.athena.base.application.meta.response.commonused.ItemResp;
import com.digiwin.athena.base.application.meta.response.permission.ActivityAccessible;
import com.digiwin.athena.base.application.service.commonused.CategoryService;
import com.digiwin.athena.base.application.service.commonused.CommonUsedService;
import com.digiwin.athena.base.application.service.commonused.ItemService;
import com.digiwin.athena.base.application.service.permission.PermissionCheckService;
import com.digiwin.athena.base.infrastructure.config.EnvProperties;
import com.digiwin.athena.base.infrastructure.manager.thememap.BaseThemeMapService;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.BaseItemDto;
import com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed.BasisReportSortMapper;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.BasisReportSortData;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.CategoryData;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.ItemData;
import com.digiwin.athena.datamap.sdk.manager.DataMapManager;
import com.digiwin.athena.datamap.sdk.meta.dto.response.TmStartProjectDTO;
import com.google.common.collect.Maps;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonUsedServiceImpl
implements CommonUsedService {
    private static final Logger logger = LoggerFactory.getLogger(CommonUsedServiceImpl.class);
    private static final long ROOT_CATE = -1L;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private ItemService itemService;
    @Resource
    private MessageUtils messageUtils;
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    BaseThemeMapService baseThemeMapService;
    @Autowired
    private PermissionCheckService permissionCheckService;
    @Autowired
    BasisReportSortMapper customSortService;

    @Override
    public CateAndItemResp cateAndItemList(AuthoredUser user, Integer plat, Long cateId) {
        List<Object> baseItemDtoList = this.queryTmDataFromKM(user, plat, null);
        Map<Object, Object> baseItemMaps = Maps.newHashMap();
        Map<String, String> baseItemCateMaps = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(baseItemDtoList)) {
            baseItemDtoList = baseItemDtoList.stream().filter(item -> item.getSubReport() == null || item.getSubReport() == false).collect(Collectors.toList());
            baseItemMaps = baseItemDtoList.stream().collect(Collectors.toMap(BaseItemDto::getCode, BaseItemDto::getName, (oldName, newName) -> newName));
            baseItemCateMaps = baseItemDtoList.stream().collect(Collectors.toMap(BaseItemDto::getCode, BaseItemDto::getCategory, (oldValue, newValue) -> newValue));
        }
        return this.queryCommonList(user, plat, cateId, baseItemMaps, baseItemCateMaps);
    }

    private CateAndItemResp queryCommonList(AuthoredUser user, Integer plat, Long cateId, Map<String, String> baseItemMaps, Map<String, String> baseItemCateMaps) {
        CateAndItemResp resp = new CateAndItemResp();
        if (Objects.isNull(cateId) || -1L == cateId) {
            cateId = -1L;
        }
        List<CategoryData> cateList = this.categoryService.queryCateList(user, plat, cateId);
        List<CategoryResp> cateRespList = this.cateDataToResp(cateList);
        List<ItemData> itemList = this.itemService.queryItemList(user, plat, cateId);
        List<ItemResp> itemRespList = this.itemDataToRespWithFilter(itemList, baseItemMaps);
        if (!itemRespList.isEmpty()) {
            for (ItemResp itemResp : itemRespList) {
                itemResp.setItemName(MapUtils.getString(baseItemMaps, (Object)itemResp.getItemCode(), (String)""));
                itemResp.setCategory(MapUtils.getString(baseItemCateMaps, (Object)itemResp.getItemCode(), (String)""));
            }
        } else {
            logger.warn("item list is empty,no need to find invoke queryEntryData");
        }
        resp.setItemsList(itemRespList);
        resp.setCateList(cateRespList);
        for (CategoryResp categoryResp : cateRespList) {
            CateAndItemResp tempResp = this.queryCommonList(user, plat, categoryResp.getId(), baseItemMaps, baseItemCateMaps);
            categoryResp.setItemsList(tempResp.getItemsList());
        }
        return resp;
    }

    @Override
    public int deleteCommUsedCate(AuthoredUser user, Long id, Integer plat) {
        int result = this.itemService.deleteItemsByCate(id, user, plat);
        if (result >= 0) {
            return this.categoryService.deleteCategory(user, id);
        }
        return -1;
    }

    @Override
    public int deleteCateAndMoveItems(AuthoredUser user, Long id, Integer plat) {
        int result = this.itemService.moveItemsByCate(id, -1L, user, plat);
        if (result >= 0) {
            return this.categoryService.deleteCategory(user, id);
        }
        return -1;
    }

    private List<CategoryResp> cateDataToResp(List<CategoryData> cateList) {
        ArrayList<CategoryResp> respList = new ArrayList<CategoryResp>();
        for (CategoryData data : cateList) {
            CategoryResp resp = new CategoryResp();
            BeanUtils.copyProperties((Object)data, (Object)resp);
            respList.add(resp);
        }
        return respList;
    }

    private List<ItemResp> itemDataToResp(List<ItemData> itemList) {
        ArrayList<ItemResp> respList = new ArrayList<ItemResp>();
        for (ItemData data : itemList) {
            ItemResp resp = new ItemResp();
            BeanUtils.copyProperties((Object)data, (Object)resp);
            respList.add(resp);
        }
        return respList;
    }

    private List<ItemResp> itemDataToRespWithFilter(List<ItemData> itemList, Map<String, String> baseItemMaps) {
        ArrayList<ItemResp> respList = new ArrayList<ItemResp>();
        for (ItemData data : itemList) {
            if (!baseItemMaps.containsKey(data.getItemCode())) {
                logger.warn("ItemCode:{} not in km result,so ignore", (Object)data.getItemCode());
                continue;
            }
            ItemResp resp = new ItemResp();
            BeanUtils.copyProperties((Object)data, (Object)resp);
            respList.add(resp);
        }
        return respList;
    }

    @Override
    public Map<String, String> queryEntryData(AuthoredUser user, Integer plat) {
        List respList = this.baseThemeMapService.getActivitiesByPattern(user, plat, null, null);
        Map<String, String> itemMaps = new HashMap<String, String>();
        if (null != respList && !respList.isEmpty()) {
            itemMaps = respList.stream().collect(Collectors.toMap(BaseItemDto::getCode, BaseItemDto::getName, (oldName, newName) -> newName));
        }
        return itemMaps;
    }

    public Map<String, String> queryEntryDataCate(AuthoredUser user, Integer plat) {
        List respList = this.baseThemeMapService.getActivitiesByPattern(user, plat, null, null);
        Map<String, String> itemMaps = new HashMap<String, String>();
        if (null != respList && !respList.isEmpty()) {
            itemMaps = respList.stream().collect(Collectors.toMap(BaseItemDto::getCode, BaseItemDto::getCategory, (oldValue, newValue) -> newValue));
        }
        return itemMaps;
    }

    @Override
    public List<TmDataListDTO> tmDataList(AuthoredUser user, Integer plat, boolean allowRepeat, Boolean searchData, List<BaseItemDto> baseDataEntryJobList, String pattern, String effect) {
        List<BaseItemDto> allTmDataList;
        if (0L == user.getTenantSid()) {
            logger.warn("tmDataList-{}:{}:{}:{}: tenantSid is null", new Object[]{user.getTenantId(), user.getUserId(), plat, LocaleContextHolder.getLocale()});
            return new ArrayList<TmDataListDTO>();
        }
        if (StringUtils.isBlank((String)effect)) {
            effect = "allow";
        }
        if (CollectionUtils.isEmpty(allTmDataList = this.getAllTmDataList(user, plat, allowRepeat, pattern, effect))) {
            return new ArrayList<TmDataListDTO>();
        }
        ArrayList<BaseItemDto> candidateDataList = new ArrayList<BaseItemDto>();
        if (!searchData.booleanValue() || CollectionUtils.isEmpty(baseDataEntryJobList)) {
            candidateDataList.addAll(allTmDataList);
        } else {
            Map checkMap = allTmDataList.stream().collect(Collectors.toMap(BaseItemDto::getCode, Function.identity(), (newVal, oldVal) -> newVal));
            for (BaseItemDto baseItemDto : baseDataEntryJobList) {
                BaseItemDto tmData = (BaseItemDto)checkMap.get(baseItemDto.getCode());
                if (null == tmData) continue;
                baseItemDto.setAccess(tmData.getAccess());
                candidateDataList.add(baseItemDto);
            }
        }
        Map<String, ItemData> commonItemMap = this.getCommonUseData(user, plat, null);
        Set<String> commonItemCodeSet = commonItemMap.keySet();
        HashSet<String> publicDataCodeSet = new HashSet<String>();
        HashMap dataMap = new HashMap();
        for (BaseItemDto baseItemDto : candidateDataList) {
            this.resetAppDataForPublic(baseItemDto);
            String appCode = StringUtils.isNotEmpty((String)baseItemDto.getAppCode()) ? baseItemDto.getAppCode() : "";
            List<BaseItemDto> list = new ArrayList();
            if (dataMap.containsKey(appCode)) {
                list = (List)dataMap.get(appCode);
            }
            if (commonItemCodeSet.contains(baseItemDto.getCode())) {
                baseItemDto.setCommonUsed(true);
                baseItemDto.setItemId(commonItemMap.get(baseItemDto.getCode()).getId());
            }
            if (this.isPublicExist(baseItemDto, publicDataCodeSet)) continue;
            list.add(baseItemDto);
            dataMap.put(appCode, list);
        }
        Map<String, List<BasisReportSortData>> customSort = this.getCustomSort(plat.toString(), user.getUserId());
        ArrayList<TmDataListDTO> tmDataListDTOList = new ArrayList<TmDataListDTO>();
        for (Map.Entry entry : dataMap.entrySet()) {
            String appCode = (String)entry.getKey();
            List baseItemDtoList = (List)entry.getValue();
            TmDataListDTO tmDataListDTO = new TmDataListDTO();
            tmDataListDTO.setAppCode(appCode);
            tmDataListDTO.setAppName(((BaseItemDto)baseItemDtoList.get(0)).getAppName());
            Map<String, Integer> tier2 = customSort.get("2").stream().collect(Collectors.toMap(e -> e.getAppCode() + "-" + e.getItemCode(), BasisReportSortData::getSort, (existing, replacement) -> existing));
            Map<String, Integer> tier3 = customSort.get("3").stream().collect(Collectors.toMap(e -> e.getAppCode() + "-" + e.getGroupCode() + "-" + e.getItemCode(), BasisReportSortData::getSort, (existing, replacement) -> existing));
            this.handleTier(tmDataListDTOList, baseItemDtoList, tmDataListDTO, tier2, tier3);
        }
        this.publicBasicDataMoveToFirst(tmDataListDTOList);
        return tmDataListDTOList;
    }

    private List<BaseItemDto> getAllTmDataList(AuthoredUser user, Integer plat, boolean allowRepeat, String pattern, String effect) {
        String string = pattern = pattern == null ? "" : pattern;
        if (Objects.equals(plat, 0)) {
            pattern = "DATA_ENTRY";
        } else if (Objects.equals(plat, 1)) {
            String string2 = pattern = StringUtils.isNotBlank((String)pattern) ? pattern : "STATEMENT";
        }
        if ("DATA_ENTRY".equals(pattern)) {
            List allTmDataList = (List)DataMapManager.getDataEntryList((String)effect).getResponse();
            return null != allTmDataList ? allTmDataList.stream().map(DataConverter.INSTANCE::toBaseItem).collect(Collectors.toList()) : new ArrayList<BaseItemDto>();
        }
        if ("STATEMENT".equals(pattern)) {
            List allTmDataList = (List)DataMapManager.getStatementList((String)effect).getResponse();
            return null != allTmDataList ? allTmDataList.stream().map(DataConverter.INSTANCE::toBaseItem).collect(Collectors.toList()) : new ArrayList<BaseItemDto>();
        }
        List<BaseItemDto> baseItems = this.queryTmDataFromKM(user, plat, pattern);
        if (CollectionUtils.isEmpty(baseItems)) {
            return new ArrayList<BaseItemDto>();
        }
        List<String> codeList = baseItems.stream().map(BaseItemDto::getCode).distinct().collect(Collectors.toList());
        if (allowRepeat) {
            codeList = codeList.stream().distinct().collect(Collectors.toList());
        }
        Map<String, String> accessMap = this.getAccessData(user, plat, codeList);
        baseItems.removeIf(baseItem -> "NOBUY".equals(accessMap.get(baseItem.getCode())));
        baseItems.forEach(baseItem -> baseItem.setAccess((String)accessMap.get(baseItem.getCode())));
        return baseItems;
    }

    private void publicBasicDataMoveToFirst(List<TmDataListDTO> tmDataListDTOList) {
        List commonAppList = tmDataListDTOList.stream().filter(data -> "PBD".equals(data.getAppCode()) || this.isCommonApp((TmDataListDTO)data)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(commonAppList)) {
            tmDataListDTOList.removeAll(commonAppList);
            tmDataListDTOList.addAll(0, commonAppList);
        }
    }

    private boolean isCommonApp(TmDataListDTO data) {
        if (CollectionUtils.isNotEmpty(data.getBaseItemDtoList())) {
            return data.getBaseItemDtoList().stream().anyMatch(baseItemDto -> BooleanUtils.isTrue((Boolean)baseItemDto.isCommonApp()));
        }
        if (CollectionUtils.isNotEmpty(data.getGroupList())) {
            for (TmDataTierListDTO tmDataTierListDTO : data.getGroupList()) {
                if (!CollectionUtils.isNotEmpty(tmDataTierListDTO.getBaseItemDtoList())) continue;
                return tmDataTierListDTO.getBaseItemDtoList().stream().anyMatch(baseItemDto -> BooleanUtils.isTrue((Boolean)baseItemDto.isCommonApp()));
            }
        }
        return true;
    }

    private void resetAppDataForPublic(BaseItemDto baseItemDto) {
        if (baseItemDto.isIfCommon()) {
            baseItemDto.setAppCode("PBD");
            baseItemDto.setAppName(this.messageUtils.getMessage("public.basic.data"));
        }
    }

    private boolean isPublicExist(BaseItemDto baseItemDto, Set<String> publicDataCode) {
        return BooleanUtils.isTrue((Boolean)baseItemDto.isIfCommon()) && !publicDataCode.add(baseItemDto.getCode());
    }

    private List<BaseItemDto> queryTmDataFromKM(AuthoredUser user, Integer plat, String pattern) {
        List respList;
        try {
            respList = this.baseThemeMapService.getActivitiesByPattern(user, plat, "/knowledgegraph/task/activitiesAndSortByPattern?pattern=", pattern);
        }
        catch (Exception e) {
            String errMsg = "User id:" + user.getUserId() + " userName:" + user.getUserName() + " query KM With plat" + plat + " Error.";
            logger.error(errMsg, (Object)e.getMessage());
            return new ArrayList<BaseItemDto>();
        }
        return respList;
    }

    private Map<String, ItemData> getCommonUseData(AuthoredUser user, Integer plat, Long cateId) {
        List<ItemData> commonItemList = this.itemService.queryItemList(user, plat, cateId);
        Map<String, Object> commonItemMap = new HashMap<String, ItemData>();
        if (CollectionUtils.isNotEmpty(commonItemList)) {
            commonItemMap = commonItemList.stream().collect(Collectors.toMap(ItemData::getItemCode, Function.identity(), (oldValue, newValue) -> newValue));
        }
        return commonItemMap;
    }

    private void handleTier(List<TmDataListDTO> tmDataListDTOList, List<BaseItemDto> baseItemDtoList, TmDataListDTO tmDataListDTO, Map<String, Integer> tier2, Map<String, Integer> tier3) {
        List tier = baseItemDtoList.stream().map(BaseItemDto::getGroupCode).collect(Collectors.toList());
        if (tier.contains(null)) {
            tmDataListDTO.setTier("2");
            tier2.put("tier", 2);
            this.sortCommon(baseItemDtoList, tier2);
            tmDataListDTO.setBaseItemDtoList(baseItemDtoList);
        } else {
            tmDataListDTO.setTier("3");
            LinkedHashMap<String, TmDataTierListDTO> duplicateMap = new LinkedHashMap<String, TmDataTierListDTO>();
            for (BaseItemDto baseItemDto : baseItemDtoList) {
                if (duplicateMap.containsKey(baseItemDto.getGroupCode())) {
                    ((TmDataTierListDTO)duplicateMap.get(baseItemDto.getGroupCode())).getBaseItemDtoList().add(baseItemDto);
                    continue;
                }
                TmDataTierListDTO tmDataTierListDTO = new TmDataTierListDTO();
                tmDataTierListDTO.setGroupCode(baseItemDto.getGroupCode());
                tmDataTierListDTO.setGroupName(baseItemDto.getGroupName());
                tmDataTierListDTO.setGroupSort(baseItemDto.getGroupSort());
                ArrayList<BaseItemDto> baseList = new ArrayList<BaseItemDto>();
                baseList.add(baseItemDto);
                tmDataTierListDTO.setBaseItemDtoList(baseList);
                duplicateMap.put(baseItemDto.getGroupCode(), tmDataTierListDTO);
            }
            ArrayList<TmDataTierListDTO> list = new ArrayList<TmDataTierListDTO>(duplicateMap.values());
            List groupSortList = list.stream().map(TmDataTierListDTO::getGroupSort).collect(Collectors.toList());
            if (groupSortList.contains(null)) {
                list.sort(Comparator.comparing(a -> {
                    try {
                        return Integer.parseInt(a.getGroupCode());
                    }
                    catch (NumberFormatException ex) {
                        return -1;
                    }
                }));
            } else {
                list.sort(Comparator.comparing(a -> {
                    try {
                        return Integer.parseInt(a.getGroupSort());
                    }
                    catch (NumberFormatException ex) {
                        return -1;
                    }
                }));
            }
            for (TmDataTierListDTO tmDataTierListDTO : list) {
                List<BaseItemDto> baseItemDtoList1 = tmDataTierListDTO.getBaseItemDtoList();
                tier3.put("tier", 3);
                this.sortCommon(baseItemDtoList1, tier3);
            }
            tmDataListDTO.setGroupList(list);
        }
        tmDataListDTOList.add(tmDataListDTO);
    }

    private void sortCommon(List<BaseItemDto> baseItemDtoList, Map<String, Integer> customSortMap) {
        List collect = baseItemDtoList.stream().map(BaseItemDto::getSort).collect(Collectors.toList());
        this.splitList(baseItemDtoList, customSortMap, collect.contains(null));
    }

    private Map<String, List<BasisReportSortData>> getCustomSort(String platform, String userId) {
        List customSortList = this.customSortService.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BasisReportSortData::getPlatform, (Object)platform)).eq(BasisReportSortData::getUserId, (Object)userId));
        Map<String, List<BasisReportSortData>> map = customSortList.stream().collect(Collectors.groupingBy(BasisReportSortData::getTier));
        map.computeIfAbsent("2", k -> new ArrayList());
        map.computeIfAbsent("3", k -> new ArrayList());
        return map;
    }

    private void splitList(List<BaseItemDto> baseItemDtoList, Map<String, Integer> customSortMap, Boolean byCharacterSort) {
        Predicate<BaseItemDto> predicateTiter2Against = e -> customSortMap.get(e.getAppCode() + "-" + e.getCode()) == null;
        Predicate<BaseItemDto> predicateTiter3Against = e -> customSortMap.get(e.getAppCode() + "-" + e.getGroupCode() + "-" + e.getCode()) == null;
        ArrayList<BaseItemDto> kmSortList = new ArrayList();
        switch (customSortMap.get("tier")) {
            case 2: {
                kmSortList = baseItemDtoList.stream().filter(predicateTiter2Against).collect(Collectors.toList());
                this.doKMSort(kmSortList, byCharacterSort);
                baseItemDtoList.removeIf(predicateTiter2Against);
                baseItemDtoList.sort(Comparator.comparing(e -> (Integer)customSortMap.get(e.getAppCode() + "-" + e.getCode())));
                break;
            }
            case 3: {
                kmSortList = baseItemDtoList.stream().filter(predicateTiter3Against).collect(Collectors.toList());
                this.doKMSort(kmSortList, byCharacterSort);
                baseItemDtoList.removeIf(predicateTiter3Against);
                baseItemDtoList.sort(Comparator.comparing(e -> (Integer)customSortMap.get(e.getAppCode() + "-" + e.getGroupCode() + "-" + e.getCode())));
            }
        }
        Comparator accessComparator = (item1, item2) -> {
            if ("forbidden".equals(item1.getAccess()) && !"forbidden".equals(item2.getAccess())) {
                return 1;
            }
            if (!"forbidden".equals(item1.getAccess()) && "forbidden".equals(item2.getAccess())) {
                return -1;
            }
            return 0;
        };
        baseItemDtoList.addAll(kmSortList);
        baseItemDtoList.sort(accessComparator);
    }

    private void doKMSort(List<BaseItemDto> itemDtos, Boolean byCharacterSort) {
        if (byCharacterSort.booleanValue()) {
            itemDtos.sort((a, b) -> Collator.getInstance(Locale.CHINA).compare(a.getCode(), b.getCode()));
        } else {
            itemDtos.sort(Comparator.comparing(a -> Integer.parseInt(a.getSort())));
        }
    }

    @Override
    public List<CategoryData> finCategory(AuthoredUser user, Integer plat, Long cateId) {
        ArrayList<CategoryData> list = new ArrayList<CategoryData>();
        List<CategoryData> cateList = this.categoryService.queryCateList(user, plat, cateId);
        CategoryData defaultData = new CategoryData();
        String name = "{\"zh_TW\":\"\u9ed8\u8a8d\u5206\u7d44\",\"en_US\":\"Default Grouping\",\"zh_CN\":\"\u9ed8\u8ba4\u5206\u7ec4\"}";
        defaultData.setCateName(MessageUtils.getMessageByCurrentLanguage((Object)name));
        defaultData.setId(Long.valueOf(-1L));
        defaultData.setParentId(Long.valueOf(-1L));
        list.add(defaultData);
        list.addAll(cateList);
        return list;
    }

    @Override
    public List<TmStartProjectDTO> startProjectList(AuthoredUser user, Boolean needSearchStartProject, List<TmStartProjectDTO> startProjectJobList) {
        List allAccessibleStartProjectList = (List)DataMapManager.getStartProjectList().getResponse();
        if (CollectionUtils.isEmpty((Collection)allAccessibleStartProjectList)) {
            return new ArrayList<TmStartProjectDTO>();
        }
        for (TmStartProjectDTO accessibleStartProject : allAccessibleStartProjectList) {
            if (null != accessibleStartProject.getCommonApp()) continue;
            accessibleStartProject.setCommonApp(Boolean.valueOf(false));
        }
        if (!needSearchStartProject.booleanValue() || CollectionUtils.isEmpty(startProjectJobList)) {
            return allAccessibleStartProjectList;
        }
        Map checkMap = allAccessibleStartProjectList.stream().collect(Collectors.toMap(TmStartProjectDTO::getCode, Function.identity(), (newVal, oldVal) -> newVal));
        ArrayList<TmStartProjectDTO> resultList = new ArrayList<TmStartProjectDTO>();
        for (TmStartProjectDTO startProjectJob : startProjectJobList) {
            TmStartProjectDTO accessibleStartProject = (TmStartProjectDTO)checkMap.get(startProjectJob.getCode());
            if (null == accessibleStartProject) continue;
            startProjectJob.setCommonApp(accessibleStartProject.getCommonApp());
            resultList.add(startProjectJob);
        }
        return resultList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="baseAudcDataSourceTransactionManager")
    public Boolean saveCustomSort(AuthoredUser user, BatchSortItemReq items) {
        HashSet<String> assistSet = new HashSet<String>();
        for (BatchSortItemReq.Item item : items.getItems()) {
            if (assistSet.add(item.getCode())) continue;
            logger.error(" Duplicate key :{}", (Object)item.getCode());
            throw BusinessException.create((Integer)-1, (String)"Duplicate key");
        }
        switch (items.getTier()) {
            case "2": {
                this.customSortService.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BasisReportSortData::getAppCode, (Object)items.getAppCode())).eq(BasisReportSortData::getUserId, (Object)user.getUserId()));
                break;
            }
            case "3": {
                this.customSortService.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BasisReportSortData::getAppCode, (Object)items.getAppCode())).eq(BasisReportSortData::getGroupCode, (Object)items.getGroupCode())).eq(BasisReportSortData::getUserId, (Object)user.getUserId()));
                break;
            }
            default: {
                logger.error("illegal tier");
                throw new RuntimeException("illegal tier");
            }
        }
        List<BasisReportSortData> entityList = this.sortReq2SortData(items, user.getUserId());
        Integer insertCount = this.customSortService.insertBatchSomeColumn(entityList);
        return null != insertCount && 0 < insertCount;
    }

    private List<BasisReportSortData> sortReq2SortData(BatchSortItemReq items, String userId) {
        ArrayList<BasisReportSortData> list = new ArrayList<BasisReportSortData>();
        items.getItems().stream().forEach(e -> {
            BasisReportSortData basisReportSortData = new BasisReportSortData();
            basisReportSortData.setAppCode(items.getAppCode());
            basisReportSortData.setAppName(items.getAppName());
            if ("3".equals(items.getTier())) {
                basisReportSortData.setGroupCode(items.getGroupCode());
                basisReportSortData.setGroupName(items.getGroupName());
            }
            basisReportSortData.setUserId(userId);
            basisReportSortData.setPlatform(items.getPlatform());
            basisReportSortData.setItemCode(e.getCode());
            basisReportSortData.setItemName(e.getName());
            basisReportSortData.setSort(e.getSort());
            basisReportSortData.setTier(items.getTier());
            list.add(basisReportSortData);
        });
        return list;
    }

    private Map<String, String> getAccessData(AuthoredUser authoredUser, Integer plat, List<String> codeList) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        ArrayList<TypeActivities> typeActivitiesList = new ArrayList<TypeActivities>();
        TypeActivities typeActivity = new TypeActivities();
        typeActivity.setType(plat + "");
        typeActivity.setTmActivityIdList(codeList);
        typeActivitiesList.add(typeActivity);
        List<TypeActivitiesAccessible> activityPermission = this.permissionCheckService.checkTypeActivitiesAccessible(authoredUser, typeActivitiesList);
        if (CollectionUtils.isEmpty(activityPermission)) {
            return resultMap;
        }
        List<ActivityAccessible> activityAccessibleList = activityPermission.get(0).getActivityAccessibleList();
        if (CollectionUtils.isEmpty(activityAccessibleList)) {
            return resultMap;
        }
        for (ActivityAccessible activityAccessible : activityAccessibleList) {
            if (Objects.isNull(activityAccessible)) continue;
            resultMap.put(activityAccessible.getTmActivityId(), activityAccessible.getAccess());
        }
        return resultMap;
    }
}

