/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.importstatistics.service.impl;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.importstatistics.esp.api.EspBody;
import com.digiwin.athena.atdm.importstatistics.esp.api.EspResponse;
import com.digiwin.athena.base.application.service.importstatistics.service.DataEntryEspService;
import com.digiwin.athena.base.application.service.importstatistics.worker.ExportFileMsg;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.exception.InvocationException;
import com.digiwin.athena.esp.sdk.exception.MDCInvocationException;
import com.digiwin.athena.esp.sdk.exception.ProductUIDNotFoundException;
import com.digiwin.athena.esp.sdk.exception.TargetInvocationException;
import com.digiwin.athena.esp.sdk.exception.TenantInfoNotFoundException;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataEntryEspServiceImpl
implements DataEntryEspService {
    private static final Logger log = LoggerFactory.getLogger(DataEntryEspServiceImpl.class);

    @Override
    public EspResponse getBaseData(Map<String, Object> requestParam, ExportFileMsg exportFileMsg, String productName, String userToken) {
        String body = "{\"std_data\":{\"parameter\":" + JsonUtils.objectToString(requestParam) + "}}";
        RequestModel requestModel = new RequestModel();
        requestModel.setHostProd("Athena");
        requestModel.setHostVer("1.0");
        requestModel.setHostId("AgileInteraction");
        requestModel.setHostAcct("athena");
        requestModel.setLanguage(exportFileMsg.getLocale());
        requestModel.setTenantId(exportFileMsg.getTenantId());
        requestModel.setServiceProd(productName);
        requestModel.setServiceName(exportFileMsg.getActionId().substring(exportFileMsg.getActionId().contains("esp_") ? 4 : 0));
        requestModel.setBodyJsonString(body);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)userToken)) {
            headerMap.put("token", exportFileMsg.getUserToken());
        } else {
            headerMap.put("security-token", exportFileMsg.getUserToken());
            headerMap.put("token", userToken);
        }
        headerMap.put("locale", exportFileMsg.getLocale());
        requestModel.setHeaderMap(headerMap);
        try {
            ResponseModel responseModel = Invoker.invokeRestSync((RequestModel)requestModel);
            String response = responseModel.getBodyJsonString();
            EspBody espBody = (EspBody)JsonUtils.jsonToObject((String)response, EspBody.class);
            EspResponse espResponse = new EspResponse();
            if ("0".equals(espBody.getStd_data().getExecution().getCode())) {
                espResponse.setStatus(EspResponse.Status.SUCCESS);
                espResponse.setData((Object)espBody);
                return espResponse;
            }
            espResponse.setData((Object)espBody);
            espResponse.setStatus(EspResponse.Status.FAILED);
            return espResponse;
        }
        catch (MDCInvocationException e) {
            log.error("error request esp", (Throwable)e);
        }
        catch (ProductUIDNotFoundException e) {
            log.error("error request esp", (Throwable)e);
        }
        catch (InvocationException e) {
            log.error("error request esp", (Throwable)e);
        }
        catch (TargetInvocationException e) {
            log.error("error request esp", (Throwable)e);
        }
        catch (TenantInfoNotFoundException e) {
            log.error("error request esp", (Throwable)e);
        }
        catch (Exception e) {
            EspResponse espResponse = new EspResponse();
            espResponse.setData(null);
            espResponse.setStatus(EspResponse.Status.FAILED);
            return espResponse;
        }
        return null;
    }
}

