/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.util;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.base.application.meta.request.attachment.AttachmentDownloadReqDTO;
import com.jugg.agile.framework.meta.exception.JaException;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class WatermarkUtil {
    private static final Logger log = LoggerFactory.getLogger(WatermarkUtil.class);

    public static byte[] addWatermarkImage(byte[] imageBytes, AttachmentDownloadReqDTO.Watermark watermark, String imageFormat) throws Exception {
        String topWatermarkText = watermark.getTopWatermarkText();
        String lowerWatermarkText = watermark.getLowerWatermarkText();
        BufferedImage srcImg = ImgUtil.read((InputStream)new ByteArrayInputStream(imageBytes));
        Graphics2D g2d = srcImg.createGraphics();
        Font font = WatermarkUtil.loadFont();
        g2d.setFont(font);
        g2d.setColor(new Color(192, 197, 203, 102));
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int textWidth = fontMetrics.stringWidth(topWatermarkText);
        int textHeight = fontMetrics.getHeight();
        int waterMarkWidth = textWidth + 200;
        int waterMarkHeight = textHeight + 200;
        for (int i = 0; i < srcImg.getWidth(); i += waterMarkWidth) {
            for (int j = 0; j < srcImg.getHeight(); j += waterMarkHeight) {
                String utf8TopWatermarkText;
                AffineTransform originalTransform = g2d.getTransform();
                g2d.rotate(-Math.toRadians(30.0), (double)i + (double)textWidth / 2.0, (double)j + (double)textHeight / 2.0);
                if (StrUtil.isBlank((CharSequence)lowerWatermarkText)) {
                    utf8TopWatermarkText = new String(topWatermarkText.getBytes(StandardCharsets.UTF_8));
                    g2d.drawString(StrUtil.sub((CharSequence)utf8TopWatermarkText, (int)0, (int)20), i, j);
                } else {
                    utf8TopWatermarkText = new String(topWatermarkText.getBytes(StandardCharsets.UTF_8));
                    String utf8LowerWatermarkText = new String(lowerWatermarkText.getBytes(StandardCharsets.UTF_8));
                    g2d.drawString(StrUtil.sub((CharSequence)utf8TopWatermarkText, (int)0, (int)20), i, j);
                    g2d.drawString(StrUtil.sub((CharSequence)utf8LowerWatermarkText, (int)0, (int)20), i, j + textHeight);
                }
                g2d.setTransform(originalTransform);
            }
        }
        g2d.dispose();
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        ImgUtil.write((Image)srcImg, (String)imageFormat, (OutputStream)bao);
        return bao.toByteArray();
    }

    public static byte[] addWatermarkPdf(byte[] pdfBytes, AttachmentDownloadReqDTO.Watermark watermark) throws Exception {
        try (PDDocument document = PDDocument.load((InputStream)new ByteArrayInputStream(pdfBytes));){
            for (PDPage page : document.getPages()) {
                PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);
                Throwable throwable = null;
                try {
                    float pageWidth = page.getMediaBox().getWidth();
                    float pageHeight = page.getMediaBox().getHeight();
                    float opacity = 0.4f;
                    double angle = Math.toRadians(30.0);
                    Color color = new Color(192, 197, 203);
                    float xInterval = 150.0f;
                    float yInterval = 150.0f;
                    BufferedImage bufferedImage = new BufferedImage(400, 100, 2);
                    Graphics2D g2d = bufferedImage.createGraphics();
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.4f));
                    Font font = WatermarkUtil.loadFont();
                    g2d.setFont(font);
                    g2d.setColor(color);
                    String topWatermarkText = watermark.getTopWatermarkText();
                    String lowerWatermarkText = watermark.getLowerWatermarkText();
                    if (StrUtil.isNotBlank((CharSequence)topWatermarkText)) {
                        if (StrUtil.isBlank((CharSequence)lowerWatermarkText)) {
                            g2d.drawString(StrUtil.sub((CharSequence)topWatermarkText, (int)0, (int)20), 10, 50);
                        } else {
                            g2d.drawString(StrUtil.sub((CharSequence)topWatermarkText, (int)0, (int)20), 10, 35);
                            g2d.drawString(StrUtil.sub((CharSequence)lowerWatermarkText, (int)0, (int)20), 10, 65);
                        }
                    }
                    g2d.dispose();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)bufferedImage, "PNG", baos);
                    baos.flush();
                    PDImageXObject pdImage = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])baos.toByteArray(), (String)"watermark");
                    for (float x = 0.0f; x < pageWidth; x += 150.0f) {
                        for (float y = 0.0f; y < pageHeight; y += 150.0f) {
                            contentStream.saveGraphicsState();
                            contentStream.transform(new Matrix((float)Math.cos(angle), (float)Math.sin(angle), -((float)Math.sin(angle)), (float)Math.cos(angle), x, y));
                            contentStream.drawImage(pdImage, 0.0f, 0.0f);
                            contentStream.restoreGraphicsState();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (contentStream == null) continue;
                    if (throwable != null) {
                        try {
                            contentStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    contentStream.close();
                }
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            document.save((OutputStream)outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    public static Font loadFont() throws Exception {
        ClassPathResource classPathResource = new ClassPathResource("fonts/msyh.ttf");
        InputStream is = classPathResource.getInputStream();
        if (is == null) {
            throw new JaException("Font file not found in resources: fonts/msyh.ttf", new Object[0]);
        }
        return Font.createFont(0, is).deriveFont(0, 12.0f);
    }
}

