/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.commonused;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.base.application.meta.dto.commonused.CategoriesDto;
import com.digiwin.athena.base.application.service.commonused.CategoryService;
import com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed.CategoryMapper;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.CategoryData;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CategoryServiceImpl
implements CategoryService {
    private static final Logger logger = LoggerFactory.getLogger(CategoryServiceImpl.class);
    private static final int TOP_STATUS = 1;
    private static final int NOT_TOP_STATUS = 0;
    private static final String CATE_DEFAULT_KEY_PREFIX = "audc:commomused:cate:unfold:";
    @Autowired
    private CategoryMapper categoryMapper;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public List<CategoryData> queryCateList(AuthoredUser user, Integer plat, Long cateId) {
        QueryWrapper cateQuery = new QueryWrapper();
        if (cateId != null) {
            cateQuery.eq((Object)"parent_id", (Object)cateId);
        }
        cateQuery.eq((Object)"plat", (Object)plat);
        cateQuery.eq((Object)"tenant_id", (Object)user.getTenantId());
        cateQuery.eq((Object)"user_id", (Object)user.getUserId());
        return this.categoryMapper.selectList((Wrapper)cateQuery);
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public CategoryData addCategory(AuthoredUser user, CategoriesDto dto) {
        CategoryData data = new CategoryData();
        data.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        data.setCreateDate(LocalDateTime.now());
        data.setModifyDate(LocalDateTime.now());
        data.setCateName(dto.getCateName());
        data.setParentId(Long.valueOf(Objects.isNull(dto.getParentId()) ? -1L : dto.getParentId()));
        data.setPlat(dto.getPlat());
        data.setUserId(user.getUserId());
        data.setTenantId(user.getTenantId());
        data.setUserName(user.getUserName());
        int result = this.categoryMapper.insert((Object)data);
        if (result > 0) {
            return data;
        }
        return null;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int deleteCategory(AuthoredUser user, Long id) {
        return this.categoryMapper.deleteById((Serializable)id);
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public int renameCategory(AuthoredUser user, Long id, String cateName) {
        CategoryData renameData = new CategoryData();
        renameData.setId(id);
        renameData.setModifyDate(LocalDateTime.now());
        renameData.setModifyUserId(user.getUserId());
        renameData.setModifyUserName(user.getUserName());
        renameData.setCateName(cateName);
        return this.categoryMapper.updateById((Object)renameData);
    }

    @Override
    public boolean isCategoryExist(AuthoredUser user, CategoriesDto dto) {
        if (StringUtils.isEmpty((String)dto.getCateName()) || "\u9ed8\u8a8d\u5206\u7d44".equals(dto.getCateName()) || "Default Grouping".equals(dto.getCateName()) || "\u9ed8\u8ba4\u5206\u7ec4".equals(dto.getCateName())) {
            return true;
        }
        QueryWrapper cateQuery = new QueryWrapper();
        cateQuery.eq((Object)"cate_name", (Object)dto.getCateName());
        cateQuery.eq((Object)"parent_id", (Object)(Objects.isNull(dto.getParentId()) ? -1L : dto.getParentId()));
        cateQuery.eq((Object)"plat", (Object)dto.getPlat());
        cateQuery.eq((Object)"user_id", (Object)user.getUserId());
        cateQuery.eq((Object)"tenant_id", (Object)user.getTenantId());
        Long result = this.categoryMapper.selectCount((Wrapper)cateQuery);
        return result > 0L;
    }

    @Override
    public CategoryData detail(Long id) {
        return (CategoryData)this.categoryMapper.selectById((Serializable)id);
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public boolean setCateTop(AuthoredUser user, Integer plat, Long cateId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"user_id", (Object)user.getUserId());
        updateWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
        updateWrapper.eq((Object)"plat", (Object)plat);
        updateWrapper.set((Object)"is_top", (Object)0);
        this.categoryMapper.update(null, (Wrapper)updateWrapper);
        UpdateWrapper topWrapper = new UpdateWrapper();
        topWrapper.eq((Object)"id", (Object)cateId);
        topWrapper.set((Object)"is_top", (Object)1);
        int result = this.categoryMapper.update(null, (Wrapper)topWrapper);
        return result >= 1;
    }

    @Override
    @Transactional(transactionManager="baseAudcDataSourceTransactionManager")
    public boolean cateUnfold(AuthoredUser user, Long cateId, Integer flag) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)cateId);
        updateWrapper.set((Object)"unfold", (Object)flag);
        int result = this.categoryMapper.update(null, (Wrapper)updateWrapper);
        return result >= 1;
    }

    @Override
    public boolean cateDefaultUnfold(AuthoredUser user, Integer plat, Integer flag) {
        String userId = user.getUserId();
        String tenantId = user.getTenantId();
        String queryKey = CATE_DEFAULT_KEY_PREFIX + plat + ":" + tenantId + ":" + userId;
        try {
            this.stringRedisTemplate.opsForValue().set((Object)queryKey, (Object)String.valueOf(flag), 7L, TimeUnit.DAYS);
        }
        catch (Exception e) {
            logger.error("insert default cate unfold info error for user:" + user.getUserId());
            return false;
        }
        return true;
    }

    @Override
    public String queryDefaultUnfold(AuthoredUser user, Integer plat) {
        String userId = user.getUserId();
        String tenantId = user.getTenantId();
        String queryKey = CATE_DEFAULT_KEY_PREFIX + plat + ":" + tenantId + ":" + userId;
        String retObj = (String)this.stringRedisTemplate.opsForValue().get((Object)queryKey);
        if (!StringUtils.isBlank((String)retObj)) {
            return retObj;
        }
        return "";
    }
}

