package com.digiwin.athena.base.application.service.commonused;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.base.application.config.BaseAudcDataSourceConfig;
import com.digiwin.athena.base.application.meta.dto.commonused.DataMigrationDto;
import com.digiwin.athena.base.infrastructure.config.EnvProperties;
import com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed.CategoryMapper;
import com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed.ItemLogMapper;
import com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed.ItemMapper;
import com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed.MenuTopMapper;
import com.digiwin.athena.base.infrastructure.mapper.audc.commonUsed.MenuUnfoldMapper;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.ItemLogData;
import lombok.extern.log4j.Log4j2;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.util.List;

import static com.digiwin.athena.base.application.config.BaseAudcDataSourceConfig.BASE_AUDC_SQL_SESSION_FACTORY_NAME;

/**
 * @description:
 * @author: dongwh
 * @date: 2022/5/26 15:10
 */
@Log4j2
@Service
public class DataMigrationServiceImpl implements DataMigrationService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    @Qualifier(BASE_AUDC_SQL_SESSION_FACTORY_NAME)
    private SqlSessionFactory sqlSessionFactory;

    @Override
    @Transactional(rollbackFor = Exception.class, transactionManager = BaseAudcDataSourceConfig.BASE_AUDC_DATASOURCE_TRANSACTION_MANAGER_BUSINESS)
    public ResponseEntity<?> insertAllCommonUserData() {
        DataMigrationDto dataMigrationDto = queryAllCommonUserData();
        if (dataMigrationDto == null) {
            return ResponseEntityWrapper.wrapperOk("访问atmc获取数据为空！");
        }
        // 采用分批提交的方式处理
        SqlSession sqlSession = sqlSessionFactory.openSession(ExecutorType.BATCH, false);
        CategoryMapper categoryMapper = sqlSession.getMapper(CategoryMapper.class);
        ItemMapper itemMapper = sqlSession.getMapper(ItemMapper.class);
        ItemLogMapper itemLogMapper = sqlSession.getMapper(ItemLogMapper.class);
        MenuTopMapper menuTopMapper = sqlSession.getMapper(MenuTopMapper.class);
        MenuUnfoldMapper menuUnfoldMapper = sqlSession.getMapper(MenuUnfoldMapper.class);
        // 是否执行成功标识
        boolean successFlag = false;
        try {
            dataMigrationDto.getCategoryDatas().forEach(categoryMapper::insert);
            dataMigrationDto.getItemDatas().forEach(itemMapper::insert);
            dataMigrationDto.getMenuTopDatas().forEach(menuTopMapper::insert);
            dataMigrationDto.getMenuUnfoldDatas().forEach(menuUnfoldMapper::insert);
            // 提升性能：选取最大的一个数据然后按照每1000条分批提交
            List<ItemLogData> itemLogDatas = dataMigrationDto.getItemLogDatas();
            for (int i = 0; i < itemLogDatas.size(); i++) {
                itemLogMapper.insert(itemLogDatas.get(i));
                if ((i + 1) % 1000 == 0 || i == itemLogDatas.size() - 1) {
                    sqlSession.commit();
                    sqlSession.clearCache();
                }
            }
            successFlag = true;
        } catch (Exception e) {
            log.error("插入数据失败！", e);
        } finally {
            sqlSession.close();
        }
        String message = MessageFormat.format("commom_category大小为：{0}，" +
                        "commom_item大小为：{1}，" +
                        "commom_item_log大小为：{2}, " +
                        "common_menu_top大小为：{3}, " +
                        "common_menu_unfold大小为：{4}, " +
                        "isSuccess：{5}",
                dataMigrationDto.getCategoryDatas().size(),
                dataMigrationDto.getItemDatas().size(),
                dataMigrationDto.getItemLogDatas().size(),
                dataMigrationDto.getMenuTopDatas().size(),
                dataMigrationDto.getMenuUnfoldDatas().size(),
                Boolean.toString(successFlag));
        return ResponseEntityWrapper.wrapperOk(message);
    }

    private DataMigrationDto queryAllCommonUserData() {
        // 调用atmc获取常用功能数据库中的数据
        String url = envProperties.getAtmcUri() + "api/amtc/v1/commonUsed/dataMigration/query";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        ResponseEntity<BaseResultDTO<DataMigrationDto>> responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<DataMigrationDto>>() {
                });
        return responseEntity.getBody().getResponse() != null ? responseEntity.getBody().getResponse() : null;
    }
}
