package com.digiwin.athena.base.application.meta.dto.userdefined;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import net.sf.json.JSONObject;

import java.time.LocalDateTime;
import java.util.List;

/**
 * UserDefinedCenterDTO Description
 *
 * @author xuxx
 * @date 2022/1/5
 * @since
 */
@Getter
@Setter
@ToString(callSuper = true)
@NoArgsConstructor
public class UserDefinedCenterDTO  {

    /**
     * 利用雪花生成的唯一ID
     */
    private Long uniqueId;

    /**
     * 用途，用在什么地方
     * FieldSeqByUser
     * OrderConditions
     * SearchConditions
     */
    private String purpose;

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 用户ID所在租户ID
     */
    private String tenantId;

    /**
     * kg中的任务code
     */
    private String tmActivityId;

    /**
     * kg中的项目code
     */
    private String tmProjectId;

    /**
     * "task-detail",
     * "project-detail"
     */
    private String pageCode;

    /*
    * 用于存放作用于哪个table上
    */
    private String tableSchema;

    /**
     * 元数据标签
     */
    private List<UserDefinedCenterMetadataResult> metadataTags;

    /**
     * 记录的落表时间-时间戳
     */
    protected LocalDateTime createDate;

    /**
     * 记录的落表时间-时间戳
     */
    protected LocalDateTime updateDate;


    /**
     *用于保存数据排序条件，延用之前的setting中的order
     * 保存结构为：
     * "tableSchema":{
     *      "order": {
     * 		    "options": [
     *                        {
     * 				"schema": "schema1",
     * 				"orderType": "string-asc",
     * 			    "order": 1,
     *            }
     * 		    ]
     * 	    }
     * 	}
     */
    private JSONObject settings;
    /**
     * 常用条件名称
     */
    private String name;
    /**
     * 常用条件集合
     */
    private List<SearchConditionGroup> searchConditions;

    /**
     * 排序条件集合
     */
    private List<SortCondition> sortConditions;

    /**
     * 是否默认
     */
    private Boolean isDefault;

    /**
     * 页面唯一编码
     */
    private String pageUniqueCode;

}
