package com.digiwin.athena.base.application.service.permission;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.application.meta.response.permission.FunctionPermissionDTO;

import java.util.List;

/**
 * PermissionService Description
 *
 * @author majianfu
 * @date 2022/5/16
 * @since
 */
public interface PermissionService {
    /**
     * 获取用户所有授权应用的权限配置
     *
     * @param authoredUser
     * @return
     */
    List<FunctionPermissionDTO> getUserAuthoredAppPermission(AuthoredUser authoredUser);

    List<FunctionPermissionDTO> getUserAuthoredAppPermissionByAppCode(AuthoredUser authoredUser,String appCode);

    /**
     * 批量获取应用的权限配置并存入redis
     * @param authoredUser
     * @param appCodes
     */
    public void batchGetAppAccessible(AuthoredUser authoredUser, List<String> appCodes);
}
