package com.digiwin.athena.base.application.service.usertrack.analyzer;

import com.digiwin.athena.base.infrastructure.meta.po.usertrack.mongo.UserTrackExtendDTO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 性能分析器
 *
 * @author majianfu
 * @date 2022/6/8
 * @since
 */
@Service
public class PerformanceAnalyzer extends AbstractReportDataAnalyzer {
    private static final String PERFORMANCE_ANALYSIS = "performance_analysis";

    /**
     * {@inheritDoc}
     */
    @Override
    public String getSourceType() {
        return PERFORMANCE_ANALYSIS;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void analysis(List<UserTrackExtendDTO> reportDataList) {
        this.userTrackMapper.safeSaveData(PERFORMANCE_ANALYSIS, reportDataList);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void clear() {
        userTrackMapper.dropCollection(PERFORMANCE_ANALYSIS);
    }
}
