/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.config;

import lombok.Generated;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexResolver;
import org.springframework.data.mongodb.core.mapping.BasicMongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

@Configuration
public class MongoIndexConfig {
    private final MongoTemplate mongoTemplate;

    @EventListener(value={ApplicationReadyEvent.class})
    public void initIndexAfterStartup() {
        MongoConverter mongoConverter = this.mongoTemplate.getConverter();
        MappingContext mappingContext = mongoConverter.getMappingContext();
        if (mappingContext instanceof MongoMappingContext) {
            MongoMappingContext mongoMappingContext = (MongoMappingContext)mappingContext;
            for (BasicMongoPersistentEntity persistentEntity : mongoMappingContext.getPersistentEntities()) {
                Class clazz = persistentEntity.getType();
                if (!clazz.isAnnotationPresent(Document.class)) continue;
                MongoPersistentEntityIndexResolver resolver = new MongoPersistentEntityIndexResolver((MappingContext)mongoMappingContext);
                IndexOperations indexOps = this.mongoTemplate.indexOps(clazz);
                resolver.resolveIndexFor(clazz).forEach(arg_0 -> ((IndexOperations)indexOps).ensureIndex(arg_0));
            }
        }
    }

    @Generated
    public MongoIndexConfig(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }
}

