package com.digiwin.athena.base.application.meta.response.permission;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * ActivityAccessible Description
 * 作业访问权限
 *
 * @author majianfu
 * @date 2021/10/11
 * @since
 */
@Data
public class ActivityAccessible {
    public ActivityAccessible() {
        this.permissionList = new HashMap<>();
    }

    public ActivityAccessible(String tmActivityId, String access) {
        this.tmActivityId = tmActivityId;
        this.access = access;
        this.permissionList = new HashMap<>();
    }

    public ActivityAccessible(String tmActivityId, String access, Map<String, String> permissionList) {
        this.tmActivityId = tmActivityId;
        this.access = access;
        this.permissionList = permissionList;
    }

    /**
     * ThemeMap定义的活动id
     */
    private String tmActivityId;

    /**
     * 访问权限校验结果
     */
    private String access;

    /**
     * 权限校验结果，如：
     * {
     * "enable": "allow",
     * "designReport": "forbidden"
     * }
     */
    private Map<String, String> permissionList;
}
