package com.digiwin.athena.base.application.config;

import com.digiwin.athena.framework.core.config.env.DwOPSEnvPropertyHandler;
import com.jugg.agile.biz.digiwin.config.common.DwPrivateDeploymentProcessor;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.middleware.mongodb.spring.JaMongoTemplateProcessor;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;

@Configuration
public class BaseMongeTemplateConfig {
    @Value("${spring.data.mongodb-track.uri}")
    private String uriTrack;

    @Value("${spring.data.mongodb-track.database}")
    private String databaseTrack;

    @Value("${spring.data.mongodb.database}")
    private String databaseLog;

    @Bean("trackMongoTemplate")
    public MongoTemplate trackMongoTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(uriTrack)).build(), null);
        MongoTemplate msgMongoTemplate = new MongoTemplate(client, databaseTrack);
        MongoConverter converter = msgMongoTemplate.getConverter();
        // 去掉_class属性
        if (converter.getTypeMapper().isTypeKey("_class")) {
            ((MappingMongoConverter) converter).setTypeMapper(new DefaultMongoTypeMapper(null));
        }

        return msgMongoTemplate;
    }

    @ConditionalOnMissingBean(name = "mongoTemplate")
    @Bean("mongoTemplate")
    public MongoTemplate mongoTemplate() {
        String uri = JaProperty.get("spring.data.mongodb.uri");
        if (DwOPSEnvPropertyHandler.getIsLocal()) {
            uri = DwPrivateDeploymentProcessor.getMongoUri();
        }
        JaLog.info("mongoTemplate : {}, {}", uri, DwOPSEnvPropertyHandler.getIsLocal());
        return JaMongoTemplateProcessor.createSimple(databaseLog, uri);
    }
}
