package com.digiwin.athena.base.application.meta.request.commonused;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * Description 用户每次排序传给接口的数据
 * Author hebaokai
 * Date 2023/8/29 10:58
 *
 * @Version 1.0
 **/
@Data
public class BatchSortItemReq {

    @NotBlank
    private String appCode;
    @NotBlank
    private String appName;
    private String groupCode;
    private String groupName;
    private Platform platform;
    @NotBlank
    private String tier;
    @Valid
    @NotEmpty
    private List<Item> items;

    public String getPlatform() {
        return platform.value;
    }


    @Data
    public static class Item{
        @NotBlank
        private String code;
        @NotBlank
        private String name;
        @NotNull
        @Min(0)
        private Integer sort;
    }



     enum Platform{
        basis("0"),
        report("1");
        private String value;

         public String getValue() {
             return value;
         }

         Platform(String value) {
            this.value = value;
        }
    }
}
