package com.digiwin.athena.base.application.service.trial;


import com.digiwin.athena.base.application.meta.request.trial.userScene.TrailUserSceneBindReq;
import com.digiwin.athena.base.application.meta.request.trial.userScene.TrialUserSceneReq;
import com.digiwin.athena.base.application.meta.request.trial.userScene.TrialUserSceneResp;

/**
 * 描述
 *
 * @author gonghongxing
 * @version 1.0
 * @since 2021/09/03 17:22:08
 */
public interface TrialUserSceneService {

    /**
     * 新增用户场景信息
     *
     * @param req req
     * @return int
     */
    int add(TrialUserSceneReq req);

    /**
     * 修改用户场景信息
     *
     * @param req req
     * @return int
     */
    int modify(TrialUserSceneReq req);

    /**
     * 删除用户对应的场景
     *
     * @param id id
     * @return int
     */
    int delete(Long id);

    /**
     * 绑定用户与场景关系
     *
     * @param req req
     */
    void bindScenes(TrailUserSceneBindReq req);

    /**
     * 查询试用场景列表
     *
     * @return list
     */
    TrialUserSceneResp listWithScenes(TrailUserSceneBindReq req);

    /**
     * 删除用户对应的场景
     *
     * @param sceneId sceneId
     * @return int
     */
    int deleteBindSceneBySceneId(Long sceneId);

    /**
     * 根据用户id和场景，删除对应的绑定关系
     * @param userId userId
     * @param sceneId sceneId
     * @return int
     */
    int deleteWithUser(String userId,Long sceneId);


}
