package com.digiwin.athena.base.application.service.userdefined;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.infrastructure.meta.bo.userdefined.mongo.UserDefinedFieldsResponse;
import com.digiwin.athena.base.application.meta.dto.userdefined.UserDefinedCenterDTO;
import com.digiwin.athena.base.application.meta.dto.userdefined.UserGridDTO;
import net.sf.json.JSONObject;

import java.util.List;
import java.util.Map;

/**
 *
 *
 *  @author xuxx
 *  @date 2022/1/5
 *  @since
 * @since
 */
public interface UserDefinedService {
    /**
     *  根据当前用户信息，保存字段顺序
     * @param user
     * @param fieldJson
     */
    void  save(AuthoredUser user, JSONObject fieldJson);

    /**
     * 恢复初始，即删除用户定义顺序
     * @param user
     * @param pageCode
     * @param tmProjectId
     * @param tmActivityId
     */
    void remove(AuthoredUser user, String pageCode, String tmProjectId , String tmActivityId,String tableSchema);

    /**
     * 根据当前用户信息，获取tag列表
     * @param user
     * @return
     */
    UserDefinedCenterDTO getFieldSeqList(AuthoredUser user, String pageCode, String tmProjectId , String tmActivityId, String tableSchema);

    UserDefinedCenterDTO getFieldSeqList(AuthoredUser user, String pageCode, String tmProjectId , String tmActivityId,String tableSchema, String pageUniqueCode);

    /**
     * 根据活动id获取用户自定义配置
     *
     * @param tmActivityIdList
     * @return
     */
    List<UserDefinedFieldsResponse> getFieldSeqList(List<String> tmActivityIdList);

    /**
     *  根据当前用户信息，保存数据排序条件
     * @param user
     * @param fieldJson
     */
    void  saveOrderConditions(AuthoredUser user, JSONObject fieldJson);

    /**
     * 根据当前用户信息，获取数据排序条件
     * @param user
     * @return
     */
    UserDefinedCenterDTO getOrderConditionsByUser(AuthoredUser user,String pageCode, String tmProjectId ,String tmActivityId,String tableSchema);

    UserDefinedCenterDTO getOrderConditionsByUser(AuthoredUser user,String pageCode, String tmProjectId ,String tmActivityId,String tableSchema, String pageUniqueCode);

    /**
     * 根据当前用户信息，获取数据排序条件集合
     * @param user
     * @param pageCode
     * @param tmProjectId
     * @param tmActivityId
     * @param tableSchema
     * @return
     */
    List<UserDefinedCenterDTO> getOrderConditionsFields(AuthoredUser user,String pageCode, String tmProjectId ,String tmActivityId,String tableSchema);


    /**
     * 恢复初始，即删除用户定义数据排序条件
     * @param user
     * @param pageCode
     * @param tmProjectId
     * @param tmActivityId
     */
    void removeOrderConditions(AuthoredUser user, String pageCode, String tmProjectId , String tmActivityId,String tableSchema);


    /**
     * 根据当前用户信息，获取展开收起状态
     * @param user
     * @return
     */
    UserDefinedCenterDTO getUserShrink(AuthoredUser user,String tmActivityId);

    /**
     * 保存展开收起状态
     * @param user
     * @param fieldJson
     */
    void saveUserShrink(AuthoredUser user, JSONObject fieldJson);


    /**
     * 表格独立使用，根据当前用户信息，获取字段及其属性
     * @param user
     * @return
     */
    Object getFieldArrtList(AuthoredUser user, String pageCode, String tmProjectId , String tmActivityId,String table);

    /**
     * 存储表格高级查询常用条件
     * @param user
     * @param userDefined
     * @return
     */
    Map<String,Object> saveSearchConditions(AuthoredUser user, UserDefinedCenterDTO userDefined);


    void delSearchConditions(AuthoredUser user,Long uniqueId);

    List<UserDefinedCenterDTO> getSearchConditions(AuthoredUser user,UserDefinedCenterDTO userDefined);

    void saveGridItems(UserGridDTO userGridDTO, AuthoredUser user);

    UserGridDTO getGridItems(UserGridDTO userGridDTO);

    void delGridItems(Long uniqueId,AuthoredUser user);
}
