package com.digiwin.athena.base.application.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.handler.BaseEntityMetaObjectHandler;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.injector.BatchInsertSqlInjector;
import org.apache.ibatis.logging.log4j2.Log4j2Impl;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.sql.DataSource;

@Configuration
@MapperScan(value = "com.digiwin.athena.base.infrastructure.mapper.audc", sqlSessionFactoryRef = BaseAudcDataSourceConfig.BASE_AUDC_SQL_SESSION_FACTORY_NAME)
@EnableTransactionManagement
public class BaseAudcDataSourceConfig {
    private static final String DATASOURCE_NAME = "baseAudcDataSource";

    /**
     * 数据源配置的前缀，必须与application.yaml中配置的对应数据源的前缀一致
     */
    private static final String DATASOURCE_PREFIX = "spring.datasource.druid.audc";

    public static final String BASE_AUDC_SQL_SESSION_FACTORY_NAME = "baseAudcSqlSessionFactory";

    public static final String BASE_AUDC_DATASOURCE_TRANSACTION_MANAGER_BUSINESS = "baseAudcDataSourceTransactionManager";

    @Primary
    @Bean(name = DATASOURCE_NAME)
    @ConfigurationProperties(prefix = DATASOURCE_PREFIX)
    public DruidDataSource attachmentDruidDataSource() {
        System.err.println("初始化BaseAudcDataSourceConfig中。。。");
        return new DruidDataSource();
    }

    @Bean(name = BASE_AUDC_SQL_SESSION_FACTORY_NAME)
    public SqlSessionFactory sqlSessionFactory(@Qualifier(DATASOURCE_NAME) DataSource dataSource) throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mapper/base/audc/*.xml"));

        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setCacheEnabled(false);
        configuration.setLogImpl(Log4j2Impl.class);
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        bean.setConfiguration(configuration);
        GlobalConfig globalConfig = GlobalConfigUtils.defaults();
        globalConfig.setBanner(false);
        globalConfig.setSqlInjector(new BatchInsertSqlInjector());
        globalConfig.setMetaObjectHandler(new BaseEntityMetaObjectHandler());

        bean.setGlobalConfig(globalConfig);

        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor(new PaginationInnerInterceptor(DbType.MYSQL));
        bean.setPlugins(interceptor);

        bean.setPlugins();
        return bean.getObject();
    }

    @Bean(name = BASE_AUDC_DATASOURCE_TRANSACTION_MANAGER_BUSINESS)
    public DataSourceTransactionManager transactionManager(@Qualifier(DATASOURCE_NAME) DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

}
