package com.digiwin.athena.base.application.constant;

/**
 * 全局常量
 *
 * @author zhouxiao
 * @date 2019/3/18
 */
public final class BaseGlobalConstant {

    public static final String IAM_USER_TOKEN = "digi-middleware-auth-user";

    public static final String IAM_APP_TOKEN = "digi-middleware-auth-app";

    public static final String IAM_IDENTITY_TYPE_TOKEN = "token";

    public static final String LANGUAGE_CN = "zh-CN";

    public static final String AREA = "CN";

    public static final String AREA_TW = "TW";

    public static final String AUTH_USER = "digi-middleware-auth-user-data";

    /**
     * 当责者
     */
    public static final String ACTION_IDENTITY_CHARGE = "charge";
    /**
     * 执行者
     */
    public static final String ACTION_IDENTITY_PERFORMER = "performer";

    /**
     * 数据库中的空主键
     */
    public static final Long EMPTY_PRIMARY_KEY = 0L;

    /**
     * 项目卡列表-异常、逾期查询条件
     */
    public static final String PROJECT_FILTER_CATEGORY_EXCEPTION = "exception";

    /**
     * 项目卡列表-正常进行查询条件
     */
    public static final String PROJECT_FILTER_CATEGORY_REGULAR = "regular";

    /**
     * 项目卡列表-全部查询条件
     */
    public static final String PROJECT_FILTER_CATEGORY_ALL = "all";

    /**
     * 逾期任务卡的类型
     */
    public final static Integer OVERDUE_BACKLOG_TYPE = 88;

    public final static String OVERDUE_BACKLOG_NAME = "{\"zh_TW\":\"逾時追踪\",\"en_US\":\"Overtime Tracking\",\"zh_CN\":\"逾时追踪\"}";

    /**
     * 逾期任务卡的操作建议
     */
    public final static String OVERDUE_WORKITEM_OPERATION = "{\"zh_TW\":\"請選擇處理方案\",\"en_US\":\"Please choose a solution\",\"zh_CN\":\"请选择处理方案\"}";

    /**
     * 逾期任务卡 pattern
     */
    public final static String OVERDUE_WORKITEM_PATTER = "UIBOT";

    /**
     * 逾期任务卡 category
     */
    public final static String OVERDUE_WORKITEM_CATEGORY = "UIBOT";

    /**
     * 逾期任务卡 任务 code
     */
    public final static String OVERDUE_WORKITEM_ACTIVITY_CODE = "uibot_overdue_task";

    /**
     * 辅助执行者的任务类型
     */
    public static final int ASSIST_TYPE = 11;

    /**
     * audc缓存前缀
     */
    public static final String AUDC_CACHE_KEY_PREFIX = "Athena:agileInteraction:audc:cache:";

    /**
     * 缓存过期时间：15分钟
     */
    public static final Long CACHE_TTL_MINUTES = 15L;

    /**
     * 公共基础资料appCode
     */
    public static final String APP_CODE_PUBLIC_BASIC_DATA = "PBD";

    /**
     * 公共基础资料appNameKey，用于i18n
     */
    public static final String APP_NAME_KEY_PUBLIC_BASIC_DATA = "public.basic.data";

}
