package com.digiwin.athena.base.application.eventbus.event;

import lombok.Data;

/**
 * 代理信息修改
 * 给atmc发送工作提醒事件
 */
@Data
public class MessageAgentChangeEvent {
    /**
     * 被代理人id
     */
    private String userId;
    /**
     * 代理人id
     */
    private String agentId;
    /**
     * 代理开始时间
     */
    private String agentBeginDate;
    /**
     * 代理结束时间
     */
    private String agentEndDate;

    private String token;
    public MessageAgentChangeEvent(String userId, String agentId, String agentBeginDate, String agentEndDate, String token) {
        this.userId = userId;
        this.agentId = agentId;
        this.agentBeginDate = agentBeginDate;
        this.agentEndDate = agentEndDate;
        this.token = token;
    }
}
