package com.digiwin.athena.base.application.service.attachment;

import com.digiwin.athena.base.application.manager.dmc.DmcService;
import com.digiwin.athena.base.application.meta.request.attachment.DeleteAgileDataReqDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;


@Slf4j
@Service("agileDataService")
public class AgileDataServiceImpl implements AgileDataService {
    @Resource
    private DmcService dmcService;

    /**
     * 批量删除敏捷实时数据
     */
    @Override
    public void deleteAgileData(String token, DeleteAgileDataReqDTO deleteAgileDataReqDTO) {
        log.info("uploadOrDeleteAttachment, body:{}", deleteAgileDataReqDTO);
        if (CollectionUtils.isEmpty(deleteAgileDataReqDTO.getDeleteFileList())) {
            log.error("The incoming list of fileIds is empty");
        }
        dmcService.deleteAgileData(token, deleteAgileDataReqDTO.getDeleteDirList(), deleteAgileDataReqDTO.getDeleteFileList());
    }
}
