package com.digiwin.athena.base.application.service.commonused;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.application.meta.dto.commonused.CategoriesDto;
import com.digiwin.athena.base.infrastructure.meta.po.commonused.CategoryData;

import java.util.List;

public interface CategoryService {
    /**
     * 查询对应的模块常用下分类信息
     *
     * @param user   用户信息
     * @param plat   所属模块0:基础资料录入 1：报表，后续有新增则依次递增
     * @param cateId 分类ID -1：根节点
     */
    List<CategoryData> queryCateList(AuthoredUser user, Integer plat, Long cateId);


    /**
     * 新增分类
     *
     * @param dto dto
     * @return int
     */
    CategoryData addCategory(AuthoredUser user, CategoriesDto dto);

    /**
     * 根据分类id删除分类
     *
     * @param user user
     * @param id   id
     * @return int
     */
    int deleteCategory(AuthoredUser user, Long id);

    /**
     * 修改分类名称
     *
     * @param user     user
     * @param id       id
     * @param cateName 分类名称
     * @return 结果
     */
    int renameCategory(AuthoredUser user, Long id, String cateName);

    /**
     * 判断当前分类名称是否存在
     *
     * @param user 用户信息
     * @param dto  分类信息
     * @return boolean
     */
    boolean isCategoryExist(AuthoredUser user, CategoriesDto dto);


    /**
     * 根据分类id查询分类的详情
     *
     * @param id id
     * @return CategoryData
     */
    CategoryData detail(Long id);

    /**
     * 设置分类为置顶
     *
     * @param user   用户信息
     * @param plat   所属模块，0:基础资料录入 1：报表，后续有新增则依次递增
     * @param cateId 分类id
     * @return 操作结果
     */
    boolean setCateTop(AuthoredUser user, Integer plat, Long cateId);

    /**
     * 设置置顶的分组收起或者展开
     *
     * @param user   用户信息
     * @param cateId 分类id
     * @param flag   0：隐藏 1：展开
     * @return 操作信息
     */
    boolean cateUnfold(AuthoredUser user, Long cateId, Integer flag);

    /**
     * 设置置顶的默认分组收起或者展开
     *
     * @param user 用户信息
     * @param plat 所属模块，0:基础资料录入 1：报表，后续有新增则依次递增
     * @param flag 0：隐藏 1：展开
     * @return 操作信息
     */
    boolean cateDefaultUnfold(AuthoredUser user, Integer plat, Integer flag);

    /**
     * 从redis中获取默认的展开设置信息
     *
     * @param user user
     * @param plat plat
     * @return String
     */
    String queryDefaultUnfold(AuthoredUser user, Integer plat);
}
