package com.digiwin.athena.base.application.service.permission;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.application.meta.request.permission.TypeActivities;
import com.digiwin.athena.base.application.meta.request.permission.TypeActivitiesAccessible;
import com.digiwin.athena.base.application.meta.response.permission.ActivityAccessible;

import java.util.List;
import java.util.Map;

/**
 * PermissionCheckService Description
 *
 * @author majianfu
 * @date 2021/10/10
 * @since
 */
public interface PermissionCheckService {
    /**
     * 校验作业的访问权限
     *
     * @param authoredUser
     * @param tmActivityIdList
     * @return
     */
    @Deprecated
    List<ActivityAccessible> checkActivityAccessible(AuthoredUser authoredUser, List<String> tmActivityIdList);

    /**
     * 校验类型作业的访问权限
     *
     * @param authoredUser
     * @param typeActivitiesList
     * @return
     */
    List<TypeActivitiesAccessible> checkTypeActivitiesAccessible(AuthoredUser authoredUser, List<TypeActivities> typeActivitiesList);

    /**
     * 校验作业是否可访问
     *
     * @param category
     * @param activityIdList
     * @return [作业ID, 访问权限（可访问：allow，其他为不可访问）]
     */
    Map<String, String> checkActivitiesAccessible(AuthoredUser authoredUser, Integer category, List<String> activityIdList);

    /**
     * 获取模组和菜单的权限
     * @param authoredUser
     * @param appCode
     * @return
     */
    Map<String, List<String>> getModuleOrMenuAccessible(AuthoredUser authoredUser, String appCode);
}
