/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.manager.dmc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.RetryableAction;
import com.digiwin.athena.appcore.util.RetryableOperationToolkit;
import com.digiwin.athena.base.application.manager.dmc.DmcService;
import com.digiwin.athena.base.application.meta.request.attachment.DmcAccount;
import com.digiwin.athena.base.application.meta.request.attachment.ShareAttachmentDTO;
import com.digiwin.athena.base.application.meta.request.attachment.UploadParamDTO;
import com.digiwin.athena.base.application.meta.response.attachment.ShareAttachmentRespDTO;
import com.digiwin.athena.base.application.meta.response.attachment.UploadAttachmentRespDTO;
import com.digiwin.athena.base.application.util.CommonInputStreamResource;
import com.digiwin.athena.base.infrastructure.config.EnvProperties;
import com.digiwin.athena.base.infrastructure.constant.AamErrorCodeEnum;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DmcServiceImpl
implements DmcService,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DmcServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;
    private Cache<String, String> dmcTokenCache;

    public void afterPropertiesSet() throws Exception {
        this.dmcTokenCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
    }

    public void destroy() throws Exception {
        this.dmcTokenCache.invalidateAll();
    }

    @Override
    public String login(String account, String password) {
        String url = this.envProperties.getDmcProperties().getUrl() + "/api/dmc/v1/auth/login";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)account) || StringUtils.isBlank((CharSequence)password)) {
            params.put("username", this.envProperties.getDmcProperties().getUserName());
            params.put("pwdhash", this.envProperties.getDmcProperties().getPwdHash());
        } else {
            params.put("username", account);
            params.put("pwdhash", password);
        }
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, String>>(){}, new Object[0]);
            if (HttpStatus.OK.value() == respEntity.getStatusCodeValue()) {
                return (String)((Map)respEntity.getBody()).get("userToken");
            }
            log.error("dmcLogin: login dmc failed, params: {}, response: {}", params, respEntity.getBody());
            throw BusinessException.create((Integer)respEntity.getStatusCodeValue(), (String)("login dmc failed, error: " + JsonUtils.objectToString((Object)respEntity.getBody())));
        }
        catch (Exception ex) {
            if (ex instanceof BusinessException) {
                throw ex;
            }
            log.error("dmcLogin: login dmc failed, params: {}, error: {}", params, (Object)ex);
            throw BusinessException.create((String)("login dmc failed, error: " + ex.getMessage()));
        }
    }

    @Override
    public void deleteAttachment(String token, Collection<String> dirIds, Collection<String> fileIds) {
        String url = this.envProperties.getDmcProperties().getUrl() + "/api/dmc/v1/buckets/Athena/files/delete/batch";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("digi-middleware-auth-user", token);
        HashMap<String, Collection<String>> params = new HashMap<String, Collection<String>>();
        params.put("dirIds", dirIds);
        params.put("fileIds", fileIds);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<String>(){}, new Object[0]);
            if (HttpStatus.OK.value() == respEntity.getStatusCodeValue()) {
                return;
            }
            log.error("deleteAttachment: delete dmc file failed, params: {}, response: {}", params, respEntity.getBody());
            throw BusinessException.create((Integer)respEntity.getStatusCodeValue(), (String)("delete dmc file failed, error: " + JsonUtils.objectToString((Object)respEntity.getBody())));
        }
        catch (Exception ex) {
            if (ex instanceof BusinessException) {
                throw ex;
            }
            log.error("deleteAttachment: delete dmc file failed, params: {}, error: {}", params, (Object)ex);
            throw BusinessException.create((String)("delete dmc file failed, error: " + ex.getMessage()));
        }
    }

    @Override
    public void loginAndDeleteAttachment(final Collection<String> dirIds, final Collection<String> fileIds, final DmcAccount dmcAccount) {
        final AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        final int maxRetryTimes = 1;
        RetryableOperationToolkit.operate((int)maxRetryTimes, (RetryableAction)new RetryableAction<Boolean>(){

            public Boolean active(int retryTime) {
                boolean flushCache = 0 != retryTime;
                String dmcToken = (String)DmcServiceImpl.this.dmcTokenCache.getIfPresent((Object)authoredUser.getToken());
                if (flushCache || StringUtils.isBlank((CharSequence)dmcToken)) {
                    DmcServiceImpl.this.dmcTokenCache.invalidate((Object)authoredUser.getToken());
                    dmcToken = null == dmcAccount ? DmcServiceImpl.this.login(null, null) : DmcServiceImpl.this.login(dmcAccount.getAccount(), dmcAccount.getPassword());
                    DmcServiceImpl.this.dmcTokenCache.put((Object)authoredUser.getToken(), (Object)dmcToken);
                }
                try {
                    DmcServiceImpl.this.deleteAttachment(dmcToken, dirIds, fileIds);
                    return false;
                }
                catch (BusinessException ex) {
                    if (ex.getCode().intValue() == HttpStatus.UNAUTHORIZED.value() && retryTime <= maxRetryTimes) {
                        return true;
                    }
                    throw ex;
                }
            }

            public boolean needRetry(Boolean result) {
                return result;
            }
        });
    }

    @Override
    public UploadAttachmentRespDTO uploadAttachment(UploadParamDTO uploadParamDTO) {
        try {
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            String dmcToken = uploadParamDTO.getToken();
            if (StringUtils.isBlank((CharSequence)dmcToken)) {
                dmcToken = this.getAttachmentToken((String)this.dmcTokenCache.getIfPresent((Object)authoredUser.getToken()), authoredUser);
            }
            HttpHeaders headers = new HttpHeaders();
            LinkedMultiValueMap param = new LinkedMultiValueMap();
            InputStream inputStream = uploadParamDTO.getInputStream();
            String uploadUrl = this.envProperties.getDmcProperties().getUrl() + "/api/dmc/v2/file/Athena/upload";
            HashMap fileMap = Maps.newHashMap();
            fileMap.put("displayName", uploadParamDTO.getFileName());
            fileMap.put("fileName", uploadParamDTO.getDownloadName());
            CommonInputStreamResource inputStreamResource = new CommonInputStreamResource(inputStream, uploadParamDTO.getDownloadName());
            param.add((Object)"file", (Object)inputStreamResource);
            param.add((Object)"tenantId", (Object)authoredUser.getTenantId());
            param.add((Object)"expireDate", (Object)uploadParamDTO.getExpireDate());
            param.add((Object)"fileInfo", (Object)fileMap);
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            headers.set("digi-middleware-auth-user", dmcToken);
            HttpEntity uploadHttpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(uploadUrl, HttpMethod.POST, uploadHttpEntity, String.class, new Object[0]);
            if (HttpStatus.OK.value() == responseEntity.getStatusCodeValue()) {
                String uploadResult = (String)responseEntity.getBody();
                JSONObject jsonObject = JSON.parseObject((String)uploadResult);
                return (UploadAttachmentRespDTO)JSONObject.parseObject((String)JSON.toJSONString((Object)jsonObject.getJSONObject("data")), UploadAttachmentRespDTO.class);
            }
        }
        catch (Exception e) {
            log.error("upload attachment failed, error: ", (Throwable)e);
            throw BusinessException.create((String)AamErrorCodeEnum.UPLOAD_ATTANCHMENT_ERROR.getErrCode(), (String)AamErrorCodeEnum.UPLOAD_ATTANCHMENT_ERROR.getErrMsg(), (Throwable)ExceptionUtils.unwrapInvocationTargetException((Throwable)e));
        }
        return null;
    }

    @Override
    public List<ShareAttachmentRespDTO> shareAttachment(ShareAttachmentDTO shareAttachmentDTO) {
        try {
            String dmcToken = shareAttachmentDTO.getToken();
            if (StringUtils.isBlank((CharSequence)dmcToken)) {
                AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
                dmcToken = this.getAttachmentToken((String)this.dmcTokenCache.getIfPresent((Object)authoredUser.getToken()), authoredUser);
            }
            if (StringUtils.isBlank((CharSequence)shareAttachmentDTO.getFileId()) && CollectionUtils.isEmpty(shareAttachmentDTO.getFileIds())) {
                return new ArrayList<ShareAttachmentRespDTO>();
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)shareAttachmentDTO.getFileId())) {
                params.put("fileId", shareAttachmentDTO.getFileId());
            }
            if (CollectionUtils.isNotEmpty(shareAttachmentDTO.getFileIds())) {
                params.put("fileIds", shareAttachmentDTO.getFileIds());
            }
            if (StringUtils.isNotBlank((CharSequence)shareAttachmentDTO.getExpireDate())) {
                params.put("expireDate", shareAttachmentDTO.getExpireDate());
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("digi-middleware-auth-user", dmcToken);
            HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
            ResponseEntity respEntity = this.restTemplate.exchange(this.envProperties.getDmcProperties().getUrl() + "/api/dmc/v2/file/Athena/share", HttpMethod.POST, httpEntity, String.class, new Object[0]);
            if (HttpStatus.OK.value() == respEntity.getStatusCodeValue()) {
                String body = (String)respEntity.getBody();
                JSONObject jsonObject = JSON.parseObject((String)body);
                ShareAttachmentRespDTO shareAttachmentRespDTO = (ShareAttachmentRespDTO)JSON.parseObject((String)JSON.toJSONString((Object)jsonObject.getJSONObject("data")), ShareAttachmentRespDTO.class);
                return Collections.singletonList(shareAttachmentRespDTO);
            }
        }
        catch (Exception e) {
            throw BusinessException.create((String)AamErrorCodeEnum.SHARE_ATTANCHMENT_ERROR.getErrCode(), (String)AamErrorCodeEnum.SHARE_ATTANCHMENT_ERROR.getErrMsg(), (Throwable)ExceptionUtils.unwrapInvocationTargetException((Throwable)e));
        }
        return null;
    }

    @Override
    public Optional<ShareAttachmentRespDTO> uploadAndShareAttachment(UploadParamDTO uploadParamDTO) {
        UploadAttachmentRespDTO uploadAttachmentRespDTO;
        String dmcToken = uploadParamDTO.getToken();
        if (StringUtils.isBlank((CharSequence)dmcToken)) {
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            dmcToken = this.getAttachmentToken((String)this.dmcTokenCache.getIfPresent((Object)authoredUser.getToken()), authoredUser);
            uploadParamDTO.setToken(dmcToken);
        }
        if (Objects.nonNull(uploadAttachmentRespDTO = this.uploadAttachment(uploadParamDTO))) {
            ShareAttachmentDTO shareAttachmentDTO = ShareAttachmentDTO.builder().fileId(uploadAttachmentRespDTO.getId()).expireDate(uploadParamDTO.getExpireDate()).token(dmcToken).build();
            List<ShareAttachmentRespDTO> shareAttachmentRespDTOS = this.shareAttachment(shareAttachmentDTO);
            return shareAttachmentRespDTOS.stream().findAny();
        }
        return Optional.empty();
    }

    @Override
    public InputStream previewFile(String fileId) {
        HttpHeaders headers = new HttpHeaders();
        String url = this.envProperties.getDmcProperties().getUrl() + "/api/dmc/v2/file/Athena/preview/" + fileId;
        ResponseEntity restRes = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), byte[].class, new Object[0]);
        return new ByteArrayInputStream((byte[])restRes.getBody());
    }

    @Override
    public Map<String, Object> deleteFile(String fileId) {
        String url = this.envProperties.getDmcProperties().getUrl() + "/api/dmc/v2/file/Athena/delete/" + fileId;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.DELETE, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Map>(){}, new Object[0]);
        return (Map)responseEntity.getBody();
    }

    @Override
    public void deleteAgileData(String token, Collection<String> dirIds, Collection<String> fileIds) {
        String url = this.envProperties.getDmcProperties().getUrl() + "/api/dmc/v2/file/Athena/delete";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("digi-middleware-auth-user", token);
        HashMap<String, Collection<String>> param = new HashMap<String, Collection<String>>();
        param.put("fileIds", fileIds);
        param.put("dirIds", dirIds);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<String>(){}, new Object[0]);
            if (HttpStatus.OK.value() == respEntity.getStatusCodeValue()) {
                return;
            }
            log.error("deleteAgileData: delete dmc AgileData failed, params: {}, response: {}", param, respEntity.getBody());
            throw BusinessException.create((Integer)respEntity.getStatusCodeValue(), (String)("delete dmc AgileData failed, error: " + JsonUtils.objectToString((Object)respEntity.getBody())));
        }
        catch (Exception ex) {
            if (ex instanceof BusinessException) {
                throw ex;
            }
            log.error("deleteAgileData: delete dmc AgileData failed, params: {}, error: {}", param, (Object)ex);
            throw BusinessException.create((String)("delete dmc AgileData failed, error: " + ex.getMessage()));
        }
    }

    @Override
    public ResponseEntity<byte[]> getAttachment(String fileId, String token) {
        String url = this.envProperties.getDmcProperties().getUrl() + "/api/dmc/v1/buckets/Athena/files/" + fileId;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("digi-middleware-auth-user", token);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<byte[]>(){}, new Object[0]);
            if (HttpStatus.OK.value() == respEntity.getStatusCodeValue()) {
                return respEntity;
            }
            log.error("getAttachment: get dmc Attachment failed, params: {}, response: {}", (Object)fileId, respEntity.getBody());
            throw BusinessException.create((Integer)respEntity.getStatusCodeValue(), (String)("get dmc Attachment failed, error: " + JsonUtils.objectToString((Object)respEntity.getBody())));
        }
        catch (Exception ex) {
            if (ex instanceof BusinessException) {
                throw ex;
            }
            log.error("getAttachment: get dmc Attachment failed, params: {}, error: {}", (Object)fileId, (Object)ex);
            throw BusinessException.create((String)("delete dmc AgileData failed, error: " + ex.getMessage()));
        }
    }

    private String getAttachmentToken(String token, AuthoredUser authoredUser) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return this.getLoginToken(authoredUser);
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)token)) {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
                headers.set("digi-middleware-auth-user", token);
                HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
                ResponseEntity respEntity = this.restTemplate.exchange(this.envProperties.getDmcProperties().getUrl() + "/api/dmc/v1/auth/token/analyze", HttpMethod.POST, httpEntity, String.class, new Object[0]);
                if (HttpStatus.OK.value() != respEntity.getStatusCodeValue()) {
                    return this.getLoginToken(authoredUser);
                }
            }
        }
        catch (Exception e) {
            return this.getLoginToken(authoredUser);
        }
        return token;
    }

    private String getLoginToken(AuthoredUser authoredUser) {
        this.dmcTokenCache.invalidate((Object)authoredUser.getToken());
        String dmcToken = this.login(null, null);
        this.dmcTokenCache.put((Object)authoredUser.getToken(), (Object)dmcToken);
        return dmcToken;
    }

    @Override
    public byte[] getMultiAttachment(Map<String, Object> param, String token) {
        String url = this.envProperties.getDmcProperties().getUrl() + "/api/dmc/v2/file/Athena/download/multi";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("digi-middleware-auth-user", token);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<byte[]>(){}, new Object[0]);
            if (HttpStatus.OK.value() == respEntity.getStatusCodeValue()) {
                return (byte[])respEntity.getBody();
            }
            log.error("getMultiAttachment failed failed, params: {}, response: {}", (Object)JSON.toJSONString(param), (Object)JSON.toJSONString((Object)respEntity.getBody()));
            throw BusinessException.create((Integer)respEntity.getStatusCodeValue(), (String)("get dmc Attachment failed, error: " + JsonUtils.objectToString((Object)respEntity.getBody())));
        }
        catch (Exception ex) {
            log.error("getMultiAttachment failed, params: " + JSON.toJSONString(param) + ", error: ", (Throwable)ex);
            throw BusinessException.create((String)("getMultiAttachment failed, error: " + ex.getMessage()));
        }
    }
}

