/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.application.service.importstatistics.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.importstatistics.configuration.DMCConfig;
import com.digiwin.athena.atdm.importstatistics.entity.DMCTokenBean;
import com.digiwin.athena.atdm.importstatistics.entity.ImportStatistics;
import com.digiwin.athena.atdm.importstatistics.util.excel.ExcelTypeEnum;
import com.digiwin.athena.atdm.importstatistics.util.excel.ExcelUtil;
import com.digiwin.athena.base.application.service.importstatistics.service.DataEntryErrorHandlerService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class RabbitDataEntryErrorHandlerServiceImpl
implements DataEntryErrorHandlerService {
    private static final Logger log = LoggerFactory.getLogger(RabbitDataEntryErrorHandlerServiceImpl.class);
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Resource
    RestTemplate dmcRestTemplate;
    @Autowired
    DMCConfig dmcConfig;
    @Autowired
    DMCTokenBean dmcTokenBean;
    @Value(value="${rest-url.dmc}")
    private String dmcUrl;
    @Value(value="${rest-url.appToken}")
    private String appToken;
    private final String EXCEL_SUFFIX = ".xlsx";
    private final String BASE_URL = this.getClass().getClassLoader().getResource("").getFile();
    private final String PACKAGE_NAME = "importError";
    private final String HEADER_KEY = "key";
    private final String HEADER_NAME = "name";
    private final String SHEET_NAME = "sheet1";

    private InputStream getErrorTableInputStream(String failedUrl) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", this.dmcTokenBean.getToken());
        headers.add("digi-middleware-auth-app", this.appToken);
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        list.add(MediaType.parseMediaType((String)ExcelTypeEnum.XLSX.value()));
        headers.setAccept(list);
        String url = this.dmcUrl + "/api/dmc/v2/file/" + this.dmcConfig.getBucket() + "/download/" + failedUrl;
        ResponseEntity restRes = this.dmcRestTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), byte[].class, new Object[0]);
        return new ByteArrayInputStream((byte[])restRes.getBody());
    }

    @Override
    public void downloadErrorTable(ImportStatistics importStatistics, List<Map> headers, Set<String> requiredFields, HttpServletResponse response) {
        Object cell1;
        XSSFWorkbook wb;
        String failedUrl = importStatistics.getFailedUrl();
        if (StringUtils.isEmpty((Object)failedUrl)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0074.getErrCode(), (String)"\u6ca1\u6709\u751f\u6210\u5bf9\u5e94\u7684\u6587\u6863");
        }
        response.setContentType(ExcelTypeEnum.XLSX.value());
        response.setCharacterEncoding("utf-8");
        String formFileName = this.getFileName(importStatistics);
        response.addHeader("Content-Disposition", "attachment;filename=" + formFileName + ".xlsx");
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        InputStream inputStream = this.getErrorTableInputStream(failedUrl);
        try {
            wb = new XSSFWorkbook(inputStream);
        }
        catch (IOException e) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0075.getErrCode(), (String)("\u89e3\u6790excel\u5931\u8d25masterid:" + importStatistics.getMasterId()));
        }
        XSSFSheet sheet = wb.getSheetAt(0);
        Row headRow1 = sheet.getRow(0);
        Row headRow2 = sheet.getRow(1);
        Map<Object, Object> headerMap = new HashMap();
        if (!CollectionUtils.isEmpty(headers)) {
            headerMap = headers.stream().collect(Collectors.toMap(s -> (String)s.get("key"), s -> (String)s.get("name")));
        }
        if (!CollectionUtils.isEmpty(headerMap)) {
            for (int i = 0; i < headRow1.getLastCellNum(); ++i) {
                cell1 = headRow1.getCell(i);
                Cell cell2 = headRow2.getCell(i);
                String langVal = (String)headerMap.get(cell2.getStringCellValue());
                String string = langVal = StringUtils.isEmpty((Object)langVal) ? cell1.getStringCellValue() : langVal;
                if (!CollectionUtils.isEmpty(requiredFields) && requiredFields.contains((String)headers.get(i).get("key"))) {
                    cell1.setCellValue((RichTextString)ExcelUtil.addRequiredMark((XSSFWorkbook)wb, (String)langVal));
                    continue;
                }
                cell1.setCellValue(langVal);
            }
        }
        try {
            ServletOutputStream os = response.getOutputStream();
            cell1 = null;
            try {
                wb.write((OutputStream)os);
                wb.close();
            }
            catch (Throwable throwable) {
                cell1 = throwable;
                throw throwable;
            }
            finally {
                if (os != null) {
                    if (cell1 != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)cell1).addSuppressed(throwable);
                        }
                    } else {
                        os.close();
                    }
                }
            }
        }
        catch (IOException e) {
            if (null != wb) {
                try {
                    wb.close();
                }
                catch (IOException ioe) {
                    log.error("\u5173\u95edwb\u5f02\u5e38", (Throwable)ioe);
                }
            }
            log.error("\u5bfc\u51fa\u5f02\u5e38\u6570\u636e\u5199\u5165\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }

    private String getFileName(ImportStatistics importStatistics) {
        String locale;
        JSONObject jsonObject = JSON.parseObject((String)importStatistics.getActivityName());
        String fileName = "";
        switch (locale = importStatistics.getLocale()) {
            case "zh_CN": {
                fileName = jsonObject.getString("default");
                break;
            }
            case "zh_TW": {
                fileName = jsonObject.getString("zh_TW");
                break;
            }
            case "en_US": {
                fileName = jsonObject.getString("en_US");
                break;
            }
            default: {
                fileName = jsonObject.getString("default");
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH_mm_ss");
        String formatTime = simpleDateFormat.format(importStatistics.getCreateTime());
        fileName = fileName + " " + formatTime;
        try {
            fileName = URLEncoder.encode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        fileName = fileName.replaceAll("\\+", "%20");
        return fileName;
    }
}

