package com.digiwin.athena.base.application.converter;

import com.digiwin.athena.base.application.meta.request.attachment.AttachmentReqDTO;
import com.digiwin.athena.base.application.meta.request.proxyinfo.ProxyInfoSaveReq;
import com.digiwin.athena.base.infrastructure.manager.eoc.dto.EmpAgentSaveReqDTO;
import com.digiwin.athena.base.infrastructure.manager.thememap.dto.BaseItemDto;
import com.digiwin.athena.base.infrastructure.meta.bo.userdefined.mongo.UserDefinedFieldsResponse;
import com.digiwin.athena.base.application.meta.dto.userdefined.UserDefinedCenterDTO;
import com.digiwin.athena.base.application.meta.dto.userdefined.UserGridDTO;
import com.digiwin.athena.base.sdk.aam.infrastructure.meta.po.AttachmentEntity;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.bo.userdefined.mongo.UserDefinedFieldsBO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserDefinedPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserGridPO;
import com.digiwin.athena.datamap.sdk.meta.dto.response.TmDataEntryDTO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

@Mapper(componentModel = "spring")
public interface DataConverter {

    DataConverter INSTANCE = Mappers.getMapper(DataConverter.class);

    EmpAgentSaveReqDTO toEmpAgentSaveReq(ProxyInfoSaveReq proxyInfoSaveReq);

    AttachmentEntity toAttachmentEntity(AttachmentReqDTO attachmentReqDTO);

    @Mapping(source = "effect", target = "access")
    BaseItemDto toBaseItem(TmDataEntryDTO tmDataEntryDTO);

    UserDefinedCenterDTO toUserDefinedCenterDTO(UserDefinedPO userDefinedPO);

    UserDefinedPO toUserDefinedPO(UserDefinedCenterDTO userDefinedCenterDTO);

    UserDefinedFieldsResponse toUserDefinedFieldsResponse(UserDefinedFieldsBO userDefinedFieldsBO);

    UserGridPO toUserGridPO(UserGridDTO userGridDTO);

    UserGridDTO toUserGridDTO(UserGridPO userGridPO);
}
