package com.digiwin.athena.base.application.meta.dto.userdefined;

import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * Description 用户保存items数据结构
 * Author hebaokai
 * Date 2024/7/11 11:44
 *
 * @Version 1.0
 **/
@Data
public class UserGridDTO {

    /**
     * 利用雪花生成的唯一ID
     */
    private Long uniqueId;

    /**
     * 作业code
     */
    private String code;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * "task-detail",
     * "project-detail"
     */
    private String pageCode;

    /**
     * item集合
     */
    private List<UserGridItemsDTO> items;


    /**
     * 记录的落表时间-时间戳
     */
    protected LocalDateTime createDate;

    /**
     * 记录的落表时间-时间戳
     */
    protected LocalDateTime updateDate;
}
