package com.digiwin.athena.base.application.meta.dto.userdefined;

import lombok.Data;

/**
 * Description 用户保存grid布局数据
 * Author hebaokai
 * Date 2024/7/11 11:39
 *
 * @Version 1.0
 **/
@Data
public class UserGridItemsDTO {

    private String id;
    /**
     * 单元格横坐标
     */
    private Integer x;
    /**
     * 单元格的纵坐标
     */
    private Integer y;
    /**
     * 单元格占据的行数量（高度）
     */
    private Integer rows;
    /**
     * 单元格占据的列数量（宽度）
     */
    private Integer cols;

    private String type;
    /**
     * 单元格占据的最小行数量（高度）
     */
    private Integer minItemRows;
    /**
     * 单元格占据的最小列数量（宽度）
     */
    private Integer maxItemRows;
    /**
     * 单元格占据的最大行数量（高度）
     */
    private Integer minItemCols;
    /**
     * 单元格占据的最大列数量（宽度）
     */
    private Integer maxItemCols;
    /**
     * 开启/禁用 内容项尺寸。
     */
    private Boolean resizeEnabled;
    /**
     * 开启/禁用 内容项拖拽。
     */
    private Boolean dragEnabled;

    /**
     * 与组件的对应关系
     */
    private String targetId;
}
