package com.digiwin.athena.base.application.meta.request.attachment;

import lombok.Data;

import java.util.List;

/**
 * @author mk
 * @date 2024/10/19 16:44
 * @description:
 */
@Data
public class AttachmentDownloadReqDTO {
    /**
     * dmc 文件 id
     */
    private String fileId;

    /**
     * dmc 文件 ids
     */
    private List<String> fileIds;

    /**
     * dmc 文件 id
     */
    private String fileName;

    /**
     * 后缀名称
     */
    private String suffixName;

    /**
     * 文件完整名称，包含了后缀名
     * fileName + suffixName
     */
    private String name;

    /**
     * Ksc 文件地址
     */
    private String fileUrl;

    /**
     * dmc 账号信息
     */
    private DmcAccount dmcAccount;

    /**
     * 文件加密
     */
    private Security security;

    /**
     * 水印
     */
    private Watermark watermark;

    @Data
    public static class DmcAccount {
        /**
         * 账号
         */
        private String account;

        /**
         * 密码
         */
        private String password;

        /**
         * 密码是否加密了
         * null/false — 未加密
         * true — 已加密
         */
        private Boolean isPasswordAlreadyEncoded;
    }

    @Data
    public static class Security {
        /**
         * 密码
         */
        private String defence;
    }

    @Data
    public static class Watermark {
        /**
         * 上行文本
         */
        private String topWatermarkText;
        /**
         * 下行文本
         */
        private String lowerWatermarkText;
    }
}
