package com.digiwin.athena.base.application.meta.request.attachment;

import com.digiwin.athena.base.sdk.aam.application.meta.validator.ValidateGroup;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.GroupSequence;
import javax.validation.constraints.NotEmpty;

@Data
@NoArgsConstructor
@GroupSequence({ValidateGroup.Save.class, ValidateGroup.Delete.class, AttachmentReqDTO.class})
public class AttachmentReqDTO {
    /**
     * 文档中心生成的附件id
     */
    @NotEmpty(groups = ValidateGroup.Delete.class)
    private String id;

    /**
     * 附件名称
     */
    @NotEmpty(groups = ValidateGroup.Save.class)
    private String name;

    /**
     * table行数据唯一标示key
     */
    @NotEmpty(groups = ValidateGroup.Save.class)
    private String rowDataKey;

    /**
     * 附件目录名称id
     */
    @NotEmpty(groups = ValidateGroup.Save.class)
    private String categoryId;

    /**
     * 附件目录名
     */
    @NotEmpty(groups = ValidateGroup.Save.class)
    private String category;

    /**
     * 租户id
     */
    @NotEmpty(groups = ValidateGroup.Save.class)
    private String tenantId;

    /**
     * 活动id
     */
    @NotEmpty(groups = ValidateGroup.Save.class)
    private String taskId;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 附件大小
     */
    private Integer size;

    /**
     * 上传者用户id
     */
    private String uploadUserId;

    /**
     * 上传者用户名称
     */
    private String uploadUserName;

    /**
     * 附件描述
     */
    private String description;

    /**
     * 上传时是否需要校验数量
     */
    private Boolean checkCount = false;

    /**
     * 允许上传的数量
     */
    private Long allowCount;

    /**
     *
     */
    private String targetSchema;

    /**
     * zip包解压密码
     */
    private String defence;
}
