package com.digiwin.athena.base.application.meta.request.permission;

import com.digiwin.athena.base.application.meta.response.permission.ActivityAccessible;
import lombok.Data;

import java.util.List;

/**
 * TypeActivitiesAccessible Description
 *
 * @author majianfu
 * @date 2021/10/29
 * @since
 */
@Data
public class TypeActivitiesAccessible {
    /**
     * 作业类别：1（任务），2（项目）
     */
    private Integer category;

    /**
     * 作业类型
     */
    private String type;

    /**
     * 每个作业的访问权限设置
     */
    private List<ActivityAccessible> activityAccessibleList;

    public TypeActivitiesAccessible() {
        this(1, null, null);
    }

    public TypeActivitiesAccessible(String type, List<ActivityAccessible> activityAccessibleList) {
        this(1, type, activityAccessibleList);
    }

    public TypeActivitiesAccessible(Integer category, String type, List<ActivityAccessible> activityAccessibleList) {
        this.category = category;
        this.type = type;
        this.activityAccessibleList = activityAccessibleList;
    }
}
