package com.digiwin.athena.base.application.meta.request.proxyinfo;

import lombok.Data;

import java.util.List;

/**
 * 保存代理人信息 请求参数
 *
 * @author chenpeng
 * @date 2024年8月29日
 * @since
 */
@Data
public class ProxyInfoSaveReq {

    /**
     * 被代理人id
     */
    private String userId;
    /**
     * 被代理人名称
     */
    private String userName;
    /**
     * 代理人id
     */
    private String agentId;
    /**
     * 代理人名称
     */
    private String agentName;
    /**
     * 代理开始时间
     */
    private String agentBeginDate;
    /**
     * 代理结束时间
     */
    private String agentEndDate;
    /**
     * 不可被代理的任务类型
     */
    private List<String> taskDefCodes;
    /**
     * 无权代理的行事历任务
     */
    private List<String> calendarTaskCodes;

    /**
     * 是否是Athena用户
     */
    private Boolean isAthena;
    /**
     * 是否需要发送消息提醒
     */
    private Boolean needSendMessage;
    /**
     * 是否需要保存无权代理的任务类型
     */
    private Boolean needSaveTaskDefCode;
}
