package com.digiwin.athena.base.application.service.action;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.action.apiError.ApiErrorInfoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

@Slf4j
@Service
public class EspApiCallbackService {

    @Autowired
    private ApiErrorInfoService apiErrorInfoService;

    @Autowired
    private AsaCallbackService asaCallbackService;

    /**
     * 回调
     * @param request
     * @param data
     */
    public void callback(HttpServletRequest request, String data) {
        String reqId = request.getHeader("digi-reqid");
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        log.error("EspApiCallbackService-user:{}", JsonUtils.objectToString(user));
        // 查询是否是ASA的请求
        Map<String, Object> asaReqMap = asaCallbackService.getAsaRequest(reqId, user);
        log.error("EspApiCallbackService-asaReqMap:{}", JsonUtils.objectToString(asaReqMap));
        if (MapUtils.isNotEmpty(asaReqMap)) {
            asaCallbackService.executeAction(data, asaReqMap, user);
        } else {
            apiErrorInfoService.callBackApiErrorInfo(user,reqId,data);
        }
    }




}
