package com.digiwin.athena.base.application.service.appexpire;

import com.digiwin.athena.base.infrastructure.manager.thememap.BaseThemeMapService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

/**
 * AppExpireServiceImpl Description
 *
 * @author majianfu
 * @date 2022/11/3
 * @since
 */
@Service
public class AppExpireServiceImpl implements AppExpireService {
    @Autowired
    private BaseThemeMapService baseThemeMapService;

    /**
     * 校验作业所属应用是否过期
     *
     * @param projectId  (可选，目前没用到)
     * @param activityId
     * @return
     */
    @Override
    public void checkActivityAppExpired(String projectId, String activityId) {
        // 调用KM获取作业定义，如果不报错则认为作业所属应用未过期，报500且错误码为RELATED_APP_EXPIRED，则认为已过期
        baseThemeMapService.checkActivityAppExpired(activityId,"activity");
    }
}
