package com.digiwin.athena.base.application.service.attachment;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.base.application.config.BaseAttachmentDataSourceConfig;
import com.digiwin.athena.base.infrastructure.mapper.attachment.AttachmentMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@Service("miscHandleServiceImpl")
public class MiscHandleServiceImpl implements MiscHandleService {

    /**
     * 租户前缀
     */
    private static final String TENANT_ID_PREFIX = "digidemo";

    /**
     * 录制租户前缀
     */
    private static final String RECORD_TENANT_ID_PREFIX = "digir";

    /**
     * 重置租户前缀
     */
    private static final String CREATE_TENANT_ID_PREFIX = "digid";

    @Resource
    private AttachmentMapper attachmentMapper;

    /**
     * 按指定的租户清除附件数据
     */
    @Override
    @Transactional(transactionManager = BaseAttachmentDataSourceConfig.BASE_ATTACHMENT_DATASOURCE_TRANSACTION_MANAGER_BUSINESS)
    public void resetDataByTenantId() {

        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();

        if (StringUtils.isEmpty(user.getTenantId())) {
            throw BusinessException.create("租户不能为空");
        }

        if (!StringUtils.startsWithIgnoreCase(user.getTenantId(), RECORD_TENANT_ID_PREFIX)
                && !StringUtils.startsWithIgnoreCase(user.getTenantId(), CREATE_TENANT_ID_PREFIX)
                && !StringUtils.startsWithIgnoreCase(user.getTenantId(), TENANT_ID_PREFIX)) {
            throw BusinessException.create(MessageFormat.format("租户 {0} 既不是录制租户也不是演示租户，不能初始化数据", user.getTenantId()));
        }

        Map<String, Object> conditionMapper = new HashMap<>();
        conditionMapper.put("tenant_id", user.getTenantId());
        attachmentMapper.deleteByMap(conditionMapper);

    }

}
