package com.digiwin.athena.base.application.service.importstatistics.service.impl;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.importstatistics.esp.api.EspBody;
import com.digiwin.athena.atdm.importstatistics.esp.api.EspResponse;
import com.digiwin.athena.base.application.service.importstatistics.service.DataEntryEspService;
import com.digiwin.athena.base.application.service.importstatistics.worker.ExportFileMsg;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.exception.InvocationException;
import com.digiwin.athena.esp.sdk.exception.MDCInvocationException;
import com.digiwin.athena.esp.sdk.exception.ProductUIDNotFoundException;
import com.digiwin.athena.esp.sdk.exception.TargetInvocationException;
import com.digiwin.athena.esp.sdk.exception.TenantInfoNotFoundException;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName EspServiceImpl
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/12/1 14:23
 * @Version 1.0
 **/
@Slf4j
@Service
public class DataEntryEspServiceImpl implements DataEntryEspService {

    @Override
    public EspResponse getBaseData(Map<String, Object> requestParam, ExportFileMsg exportFileMsg, String productName, String userToken) {
        String body = "{\"std_data\":{\"parameter\":" + JsonUtils.objectToString(requestParam) + "}}";
        // 建立RequestModel物件並設定內容
        RequestModel requestModel = new RequestModel();
        requestModel.setHostProd("Athena");
        requestModel.setHostVer("1.0");
        requestModel.setHostId("AgileInteraction");
        requestModel.setHostAcct("athena");
        requestModel.setLanguage(exportFileMsg.getLocale());
        requestModel.setTenantId(exportFileMsg.getTenantId());
        requestModel.setServiceProd(productName);
        requestModel.setServiceName(exportFileMsg.getActionId().substring(exportFileMsg.getActionId().contains("esp_") ? 4 : 0));
        requestModel.setBodyJsonString(body);
        //header
        Map<String, String> headerMap = new HashMap<>();
        if(StringUtils.isEmpty(userToken)){
            headerMap.put("token", exportFileMsg.getUserToken());
        }else {
            headerMap.put("security-token", exportFileMsg.getUserToken());
            headerMap.put("token", userToken);
        }
        headerMap.put("locale", exportFileMsg.getLocale());
        requestModel.setHeaderMap(headerMap);
        ResponseModel responseModel;
        try {
            responseModel = Invoker.invokeRestSync(requestModel);
            String response = responseModel.getBodyJsonString();
            EspBody espBody = JsonUtils.jsonToObject(response, EspBody.class);
            EspResponse espResponse = new EspResponse();
            if ("0".equals(espBody.getStd_data().getExecution().getCode())) {
                espResponse.setStatus(EspResponse.Status.SUCCESS);
                espResponse.setData(espBody);
                return espResponse;
            } else {
                espResponse.setData(espBody);
                espResponse.setStatus(EspResponse.Status.FAILED);
                return espResponse;
            }
        } catch (MDCInvocationException e) {
            log.error("error request esp", e);
        } catch (ProductUIDNotFoundException e) {
            log.error("error request esp", e);
        } catch (InvocationException e) {
            log.error("error request esp", e);
        } catch (TargetInvocationException e) {
            log.error("error request esp", e);
        } catch (TenantInfoNotFoundException e) {
            log.error("error request esp", e);
        } catch (Exception e) {
            EspResponse espResponse = new EspResponse();
            espResponse.setData(null);
            espResponse.setStatus(EspResponse.Status.FAILED);
            return espResponse;
        }
        return null;
    }

}
